package gu.sql2java.manager.parser;

import java.util.Map;

import com.google.common.collect.ImmutableMap;

import gu.sql2java.Constant;
import gu.sql2java.manager.phoenix.PhoenixNormalizer;

/**
 * @author guyadong
 * @since 3.17.0
 */
public class SqlSyntaxNormalizers implements Constant {
    /** 保存不同类型的数据库的对应的 {@link SqlSyntaxNormalizer} 对象 */
    private static Map<String, SqlSyntaxNormalizer> sqlNormalizer = 
            ImmutableMap.of(
                    PRODUCT_NAME_PHOENIX,new PhoenixNormalizer());
    /**
     * 返回指定数据库引擎的{@link SqlSyntaxNormalizer},没有返回{@code null}
     * @param engine
     */
    public static SqlSyntaxNormalizer normalizerOf(String engine){
        return sqlNormalizer.get(engine);
    }
}
