package gu.sql2java.manager.phoenix;

import gu.sql2java.manager.SqlFormatters.QuoteFormatter;
import gu.sql2java.utils.CaseSupport;

/**
 * @author guyadong
 * @since 3.14.0
 */
public class PhonenixSqlFormatter extends QuoteFormatter {
    
    public PhonenixSqlFormatter() {
        super("\"");
    }
    
    @Override
    public String tablename(String tablename) {
        return quoteIf(tablename, CaseSupport::hasLowerCase);
    }

    @Override
    public String columname(String columname) {
        return quoteIf(columname, CaseSupport::hasLowerCase);
    }

}
