package gu.sql2java.manager.sqlite;

import static gu.sql2java.SimpleLog.log;

import javax.sql.DataSource;

import org.sqlite.SQLiteConfig;
import org.sqlite.javax.SQLiteConnectionPoolDataSource;

import gu.sql2java.manager.DataSourceConfig;
import gu.sql2java.manager.DataSourceFactory;

/**
 * 基于sqlite-jdbc实例{@link DataSourceFactory}接口
 * @author guyadong
 *
 */
public class SqliteDataSourceFactory implements DataSourceFactory{
	public SqliteDataSourceFactory() {
	}

	
    private void logDatabaseParameters(DataSourceConfig config){
        if(DataSourceConfig.isDebugOutput()){
            log("database using debug environment parameter: ");
            log("datasource = " + config.getDataSource());
            log("jdbcUrl = " + config.getJdbcUrl());
        }
    }
	@Override
	public DataSource createDataSource(DataSourceConfig config){
		logDatabaseParameters(config);
		SQLiteConfig sqLiteConfig = new SQLiteConfig();
		// enable  ON DELETE CASCADE for foreign keys
		sqLiteConfig.enforceForeignKeys(true);
		SQLiteConnectionPoolDataSource ds = new SQLiteConnectionPoolDataSource(sqLiteConfig);  
		ds.setUrl(config.getJdbcUrl());
		return ds; 

	}
	@Override
	public void destroy(DataSource dataSource) {
	}
}
