package gu.sql2java.manager.utils;

import static com.gitee.l0km.com4j.base.ConditionChecks.format;

import javax.annotation.Nullable;

import gu.sql2java.manager.store.BaseColumnStore.URLParseException;

/**
 * URL解析检查工具类
 * @author guyadong
 *
 */
public class URLParseChecks {

	public URLParseChecks() {
	}
	/**
	 * 执行表达式,为false时抛出{@link URLParseException}异常
	 * @param b
	 * @param errorMessageTemplate a template for the exception message should the check fail. The
	 *     message is formed by replacing each {@code %s} placeholder in the template with an
	 *     argument. These are matched by position - the first {@code %s} gets {@code
	 *     errorMessageArgs[0]}, etc. Unmatched arguments will be appended to the formatted message in
	 *     square braces. Unmatched placeholders will be left as-is.
	 * @param errorMessageArgs the arguments to be substituted into the message template. Arguments
	 *     are converted to strings using {@link String#valueOf(Object)}.
	 * @throws URLParseException
	 */
	public static void checkURLParse(
			boolean b, 
			@Nullable String errorMessageTemplate, 
			@Nullable Object... errorMessageArgs) throws URLParseException {
		if (!b) {
			throw new URLParseException(format(errorMessageTemplate, errorMessageArgs));
		}
	}
	/**
	 * 执行表达式,为false时抛出{@link URLParseException}异常
	 *
	 * <p>See {@link #checkURLParse(boolean, String, Object...)} for details.
	 * @throws URLParseException 
	 */
	public static void checkURLParse(
			boolean b, 
			@Nullable String errorMessageTemplate, @Nullable Object p1) throws URLParseException {
		if (!b) {
			throw new URLParseException(format(errorMessageTemplate, p1));
		}
	}
}
