package gu.sql2java.generator;

import java.io.File;
import java.net.URL;
import org.apache.maven.plugin.AbstractMojo;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

import net.gdface.utils.BinaryUtils;

/**
 * maven 插件<br>
 * 输出的默认配置文件
 * 
 * @author guyadong
 *
 */
@Mojo(name = "help", requiresProject = false)
public class HelpMojo extends AbstractMojo {
	/**
	 * properties file output path<br>
	 * output to "standard" output stream if absent
	 */
	@Parameter(property = "sql2java.output")
	private File outputFile;

	public HelpMojo() {
	}

	@Override
	public void execute() throws MojoExecutionException, MojoFailureException {
		
		try {
			URL url = HelpMojo.class.getResource("/sql2java.properties");
			byte[] content = BinaryUtils.getBytes(url);
			if(outputFile != null){
				getLog().info("OUTPUT PROPRETIES TO " + outputFile);
				BinaryUtils.saveBytes(content, outputFile, true);
			}else{
				getLog().info("=========SQL2JAVA PROPERTIES============");
				System.out.println(new String(content,"UTF-8"));
				getLog().info("========COMMAND LINE OPTIONS=============");
				Generator.main("--help");
			}
		} catch (Exception e) {
			throw new MojoExecutionException(e.getMessage(),e);
		}
	}
}
