package gu.sql2java.generator;

import static gu.sql2java.generator.GeneratorConstants.*;

import java.io.File;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;

/**
 * maven 插件<br>
 * 根据提供的配置文件，生成数据库操作代码(java),等同于执行{@link gu.sql2java.generator.Generator#main(String[])}
 * 
 * @author guyadong
 *
 */
@Mojo(name = "generate", requiresProject = false)
public class RunMojo extends AbstractMojo {
	/**
	 * properties file path for configuration
	 */
	@Parameter(property = "sql2java.propfile",required=true)
	private File propFile;

	/**
	 * class path for lookup JDBC driver,split by ';'  on Windows or ':' on Linux
	 */
	@Parameter(property = "sql2java.classpath",defaultValue="")
	private List<String> classpath;
	public RunMojo() {
	}

	@Override
	public void execute() throws MojoExecutionException, MojoFailureException {
		List<String> args = Lists.newLinkedList();
		args.add("--" + PROPFILE_OPTION_LONG);
		args.add(propFile.getAbsolutePath());
		if(!classpath.isEmpty()){
			args.add("--" + CLASSPATH_OPTION_LONG);
			args.add(Joiner.on(';').join(classpath));
		}
		Generator.main(args.toArray(new String[args.size()]));
	}
}
