/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.observer.exe.mysql;

import gu.sql2java.observer.JDBCUtility;
import gu.sql2java.observer.exe.mysql.InstallerConstants;
import gu.sql2java.observer.exe.mysql.InstallerMain;
import net.gdface.cli.BaseAppConfig;
import net.gdface.utils.ConditionChecks;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class InstallerConfig
extends BaseAppConfig
implements InstallerConstants {
    static final InstallerConfig CONFIG = new InstallerConfig();
    private String jdbcurl;
    private String username;
    private String password;
    private String schema;
    private String tablepattern;
    private boolean remove;
    private boolean udf;

    public InstallerConfig() {
        super(true);
        this.options.addOption(Option.builder((String)"l").longOpt("url").desc("jdbc url for MySQL,default:jdbc:mysql://localhost:3306/test?characterEncoding=utf8&useInformationSchema=true&user=root").numberOfArgs(1).build());
        this.options.addOption(Option.builder((String)"n").longOpt("username").desc("jdbc username for MySQL").numberOfArgs(1).build());
        this.options.addOption(Option.builder((String)"a").longOpt("password").desc("jdbc passworld for MySQL").numberOfArgs(1).build());
        this.options.addOption(Option.builder((String)"t").longOpt("tablepattern").desc("pattern of table name,requred by install/remove trigger,such as, 'ro_person',or 'ro_%'").numberOfArgs(1).build());
        this.options.addOption(Option.builder((String)"r").longOpt("remove").desc("remove trigger/UDF,otherwise install").numberOfArgs(0).build());
        this.options.addOption(Option.builder((String)"u").longOpt("udf").desc("install/remove UDF,otherwise for trigger").numberOfArgs(0).build());
        this.defaultValue.setProperty("url", (Object)"jdbc:mysql://localhost:3306/test?characterEncoding=utf8&useInformationSchema=true&user=root");
        this.defaultValue.setProperty("username", null);
        this.defaultValue.setProperty("password", null);
        this.defaultValue.setProperty("tablepattern", null);
        this.defaultValue.setProperty("remove", (Object)false);
        this.defaultValue.setProperty("udf", (Object)false);
    }

    public void loadConfig(Options options, CommandLine cmd) throws ParseException {
        super.loadConfig(options, cmd);
        this.jdbcurl = (String)this.getProperty("url");
        this.username = (String)this.getProperty("username");
        this.password = (String)this.getProperty("password");
        this.schema = JDBCUtility.parseSchemaFromJDBCURL((String)this.jdbcurl);
        this.tablepattern = (String)this.getProperty("tablepattern");
        this.remove = (Boolean)this.getProperty("remove");
        this.udf = (Boolean)this.getProperty("udf");
        ConditionChecks.checkTrue((this.udf || null != this.tablepattern ? 1 : 0) != 0, MissingOptionException.class, (Object)"Missing required option: t");
    }

    protected String getAppName() {
        return InstallerMain.class.getSimpleName();
    }

    protected String getHeader() {
        return "ro_observer UDF/\u89e6\u53d1\u5668\u5b89\u88c5/\u5220\u9664\u5de5\u5177";
    }

    public String getJdbcurl() {
        return this.jdbcurl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTablepattern() {
        return this.tablepattern;
    }

    public boolean isRemove() {
        return this.remove;
    }

    public boolean isUdf() {
        return this.udf;
    }
}

