/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.observer.exe.mysql;

import gu.sql2java.SimpleLog;
import gu.sql2java.observer.JDBCUtility;
import gu.sql2java.observer.TriggerInstaller;
import gu.sql2java.observer.exe.mysql.InstallerConfig;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;

public class InstallerMain {
    public static void main(String ... argv) throws SQLException {
        InstallerConfig.CONFIG.parseCommandLine(argv);
        try (Connection con = JDBCUtility.createConnection((String)InstallerConfig.CONFIG.getJdbcurl(), (String)InstallerConfig.CONFIG.getUsername(), (String)InstallerConfig.CONFIG.getPassword(), null);){
            JDBCUtility.checkDatatbaseVersion((DatabaseMetaData)con.getMetaData(), (String)"MySQL", (String)"5.7", null);
            TriggerInstaller installer = new TriggerInstaller(false);
            if (InstallerConfig.CONFIG.isUdf()) {
                if (InstallerConfig.CONFIG.isRemove()) {
                    installer.removeUDF(InstallerConfig.CONFIG.getJdbcurl(), InstallerConfig.CONFIG.getUsername(), InstallerConfig.CONFIG.getPassword());
                } else {
                    installer.installUDF(InstallerConfig.CONFIG.getJdbcurl(), InstallerConfig.CONFIG.getUsername(), InstallerConfig.CONFIG.getPassword());
                }
            } else {
                List tablenames = JDBCUtility.getTablenames((DatabaseMetaData)con.getMetaData(), null, (String)InstallerConfig.CONFIG.getSchema(), (String)InstallerConfig.CONFIG.getTablepattern());
                if (!tablenames.isEmpty()) {
                    for (String schematable : tablenames) {
                        if (InstallerConfig.CONFIG.isRemove()) {
                            installer.removeTrigger(schematable, InstallerConfig.CONFIG.getJdbcurl(), InstallerConfig.CONFIG.getUsername(), InstallerConfig.CONFIG.getPassword(), null);
                            continue;
                        }
                        installer.installTrigger(schematable, InstallerConfig.CONFIG.getJdbcurl(), InstallerConfig.CONFIG.getUsername(), InstallerConfig.CONFIG.getPassword(), null);
                    }
                } else {
                    SimpleLog.log((String)"NOT FOUD TABLE for {}.{}", (Object[])new Object[]{InstallerConfig.CONFIG.getSchema(), InstallerConfig.CONFIG.getTablepattern()});
                }
            }
        }
    }
}

