package gu.sql2java.observer.exe.mysql;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

import com.gitee.l0km.com4j.base.ConditionChecks;
import com.gitee.l0km.com4j.cli.BaseAppConfig;

import static gu.sql2java.observer.JDBCUtility.parseSchemaFromJDBCURL;
/**
 * 终端命令行配置参数
 * @author guyadong
 *
 */
public class InstallerConfig extends BaseAppConfig implements InstallerConstants {

	static final InstallerConfig CONFIG = new InstallerConfig();

	private String jdbcurl;

	private String username;

	private String password;

	private String schema;

	private String tablepattern;

	private boolean remove;

	private boolean udf;

	public InstallerConfig() {
		super(true);

		options.addOption(Option.builder(JDBC_URL_OPTION).longOpt(JDBC_URL_OPTION_LONG)
				.desc(JDBC_URL_OPTION_DESC).numberOfArgs(1).build());
		
		options.addOption(Option.builder(JDBC_USERNAME_OPTION).longOpt(JDBC_USERNAME_OPTION_LONG)
				.desc(JDBC_USERNAME_OPTION_DESC).numberOfArgs(1).build());
		
		options.addOption(Option.builder(JDBC_PASSWORD_OPTION).longOpt(JDBC_PASSWORD_OPTION_LONG)
				.desc(JDBC_PASSWORD_OPTION_DESC).numberOfArgs(1).build());
		
		options.addOption(Option.builder(TABLEPATTERN_OPTION).longOpt(TABLEPATTERN_OPTION_LONG)
				.desc(TABLEPATTERN_OPTION_DESC).numberOfArgs(1).build());
		
		options.addOption(Option.builder(REMOVE_OPTION).longOpt(REMOVE_OPTION_LONG)
				.desc(REMOVE_OPTION_DESC).numberOfArgs(0).build());
		
		options.addOption(Option.builder(UDF_OPTION).longOpt(UDF_OPTION_LONG)
				.desc(UDF_OPTION_DESC).numberOfArgs(0).build());
		
		
		defaultValue.setProperty(JDBC_URL_OPTION_LONG, DEFAULT_MYSQL_LOCAL_URL);
		defaultValue.setProperty(JDBC_USERNAME_OPTION_LONG, null);
		defaultValue.setProperty(JDBC_PASSWORD_OPTION_LONG, null);
		defaultValue.setProperty(TABLEPATTERN_OPTION_LONG, null);
		defaultValue.setProperty(REMOVE_OPTION_LONG, false);
		defaultValue.setProperty(UDF_OPTION_LONG, false);

	}
	@Override
	public void loadConfig(Options options, CommandLine cmd) throws ParseException {
		super.loadConfig(options, cmd);
		this.jdbcurl = getProperty(JDBC_URL_OPTION_LONG);
		this.username = getProperty(JDBC_USERNAME_OPTION_LONG);
		this.password = getProperty(JDBC_PASSWORD_OPTION_LONG);
		this.schema = parseSchemaFromJDBCURL(this.jdbcurl);
		this.tablepattern = getProperty(TABLEPATTERN_OPTION_LONG);
		this.remove = getProperty(REMOVE_OPTION_LONG);
		this.udf = getProperty(UDF_OPTION_LONG);
		// 安装trigger时必须指定tablepattern
		ConditionChecks.checkTrue(this.udf || null != this.tablepattern, MissingOptionException.class, "Missing required option: " + TABLEPATTERN_OPTION);
	}
	@Override
	protected String getAppName() {
		return InstallerMain.class.getSimpleName();
	}
	@Override
	protected String getHeader() {
		return "ro_observer UDF/触发器安装/删除工具";
	}
	public String getJdbcurl() {
		return jdbcurl;
	}
	public String getUsername() {
		return username;
	}
	public String getPassword() {
		return password;
	}
	public String getSchema() {
		return schema;
	}
	public String getTablepattern() {
		return tablepattern;
	}
	public boolean isRemove() {
		return remove;
	}
	public boolean isUdf() {
		return udf;
	}
}
