/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.observer;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import gu.simplemq.SimpleLog;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class JDBCUtility
extends gu.sql2java.utils.JDBCUtility {
    public static void checkDatatbaseVersion(DatabaseMetaData metaData, String requiredProductName, String requiredMinVersion, String requiredMaxVersion) throws SQLException {
        String productName = ((DatabaseMetaData)Preconditions.checkNotNull((Object)metaData, (Object)"metaData is null")).getDatabaseProductName();
        DefaultArtifactVersion minVersion = new DefaultArtifactVersion((String)Preconditions.checkNotNull((Object)requiredMinVersion, (Object)"requiredMinVersion is null"));
        DefaultArtifactVersion version = new DefaultArtifactVersion(metaData.getDatabaseProductVersion());
        SimpleLog.log((String)"database {} {}", (Object[])new Object[]{productName, version});
        Preconditions.checkState((boolean)productName.equals(requiredProductName), (String)"%s required", (Object)requiredMinVersion);
        Preconditions.checkState((version.compareTo((ArtifactVersion)minVersion) >= 0 ? 1 : 0) != 0, (String)"Sorry, %s min version %s is required", (Object)requiredProductName, (Object)minVersion);
        if (!Strings.isNullOrEmpty((String)requiredMaxVersion)) {
            DefaultArtifactVersion maxVersion = new DefaultArtifactVersion(requiredMaxVersion);
            Preconditions.checkState((version.compareTo((ArtifactVersion)maxVersion) <= 0 ? 1 : 0) != 0, (String)"Sorry, %s max version %s is required", (Object)requiredProductName, (Object)maxVersion);
        }
    }
}

