/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.observer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import gu.simplemq.Channel;
import gu.simplemq.ISubscriber;
import gu.simplemq.exceptions.SmqUnsubscribeException;
import gu.simplemq.json.BaseJsonEncoder;
import gu.sql2java.BaseBean;
import gu.sql2java.ListenerContainer;
import gu.sql2java.RowMetaData;
import gu.sql2java.TableListener;
import gu.sql2java.UnnameRow;
import gu.sql2java.observer.JDBCUtility;
import gu.sql2java.observer.SimpleRowMetaData;
import gu.sql2java.observer.StoreType;
import gu.sql2java.observer.TriggerType;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class RowObserver {
    private static final ExecutorService executor = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("sql2java-row-observer-%d").build()));
    private ISubscriber subscriber;
    private final ConcurrentHashMap<String, ListenerContainer<BaseBean>> containers = new ConcurrentHashMap(16);
    public static final String TOPIC_PREFIX = "ROWOVS/";
    private static final String JN_TRIGGER_TYPE = "triggerType";
    private static final String JN_STORE_TYPE = "rowType";
    private static final String JN_ROW = "row";
    private static final String JN_OLD = "OLD";
    private static final String JN_NEW = "NEW";

    public RowObserver(ISubscriber subscriber) {
        this.subscriber = (ISubscriber)Preconditions.checkNotNull((Object)subscriber, (Object)"subscriber is null");
    }

    public void register(String qualifiedName, ListenerContainer<BaseBean> container) {
        this.containers.put(qualifiedName, (ListenerContainer<BaseBean>)Preconditions.checkNotNull(container, (Object)"container is null"));
        this.subscriber.register(new Channel[]{new TableObserverChannel(qualifiedName, container)});
    }

    public TableObserverChannel register(String qualifiedName, SimpleRowMetaData rowMetaData) {
        Preconditions.checkArgument((null == RowMetaData.getMetaDataUnchecked((String)JDBCUtility.parseTablenme((String)((String)Preconditions.checkNotNull((Object)qualifiedName, (Object)"schematable is null")))) ? 1 : 0) != 0, (String)"schematable:%s be defined in RowMetaData,cannot use the method", (Object)qualifiedName);
        this.containers.putIfAbsent(qualifiedName, (ListenerContainer<BaseBean>)new ListenerContainer(false, ListenerContainer.FireType.ROW_OBSERVER));
        ListenerContainer<BaseBean> container = this.containers.get(qualifiedName);
        TableObserverChannel channel = new TableObserverChannel(qualifiedName, container, rowMetaData);
        this.subscriber.register(new Channel[]{channel});
        return channel;
    }

    public static class TableObserverChannel
    extends Channel<String> {
        private final ListenerContainer<BaseBean> container;
        private final BaseJsonEncoder jsonEncoder;
        private final RowMetaData rowMetaData;

        protected TableObserverChannel(String schematable, ListenerContainer<BaseBean> container) {
            this(schematable, container, RowMetaData.getMetaData((String)JDBCUtility.parseTablenme((String)schematable)));
        }

        protected TableObserverChannel(String schematable, ListenerContainer<BaseBean> container, RowMetaData rowMetaData) {
            super(RowObserver.TOPIC_PREFIX + (String)Preconditions.checkNotNull((Object)schematable, (Object)"schematable is null"));
            this.container = (ListenerContainer)Preconditions.checkNotNull(container, (Object)"container is null");
            this.jsonEncoder = BaseJsonEncoder.getEncoder();
            this.rowMetaData = (RowMetaData)Preconditions.checkNotNull((Object)rowMetaData, (Object)"rowMetaData is null");
        }

        private BaseBean parseBean(JSONObject row, String name) {
            String json = (String)row.getObject(name, String.class);
            UnnameRow bean = null;
            if (null != json) {
                JSONObject jsonObject = (JSONObject)this.jsonEncoder.fromJson(json, JSONObject.class);
                if (UnnameRow.class.equals((Object)this.rowMetaData.beanType)) {
                    bean = new UnnameRow(this.rowMetaData);
                } else {
                    try {
                        bean = (BaseBean)this.rowMetaData.beanType.newInstance();
                    }
                    catch (Exception e) {
                        Throwables.throwIfUnchecked((Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                for (int i = 0; i < this.rowMetaData.columnCount; ++i) {
                    Object origin = jsonObject.get(this.rowMetaData.columnNames.get(i));
                    if (null == origin) continue;
                    Object value = TypeUtils.cast((Object)origin, (Class)((Class)this.rowMetaData.columnTypes.get(i)), null);
                    bean.setValue(i, value);
                }
                bean.resetIsModified();
            }
            return bean;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void doOnSubscribe(String t) {
            try {
                JSONObject jsonObject = (JSONObject)JSON.parseObject((String)t, JSONObject.class);
                TriggerType triggerType = (TriggerType)((Object)jsonObject.getObject(RowObserver.JN_TRIGGER_TYPE, TriggerType.class));
                Preconditions.checkNotNull((Object)((Object)triggerType), (Object)"triggerType field is null");
                StoreType storeType = (StoreType)((Object)jsonObject.getObject(RowObserver.JN_STORE_TYPE, StoreType.class));
                Preconditions.checkArgument((boolean)StoreType.JSON.equals((Object)storeType), (String)"UNSUPPORTED storeType %s", (Object)((Object)storeType));
                JSONObject row = (JSONObject)jsonObject.getObject(RowObserver.JN_ROW, JSONObject.class);
                BaseBean oldBean = this.parseBean(row, RowObserver.JN_OLD);
                BaseBean newBean = this.parseBean(row, RowObserver.JN_NEW);
                triggerType.checkRow(oldBean, newBean);
                if (triggerType.name().endsWith("_UPDATE")) {
                    int modified = 0;
                    for (int i = 0; i < this.rowMetaData.columnCount; ++i) {
                        if (Objects.equal((Object)oldBean.getValue(i), (Object)newBean.getValue(i))) continue;
                        modified |= 1 << i;
                    }
                    newBean.setModified(modified);
                }
                this.container.firer(ListenerContainer.FireType.ROW_OBSERVER);
                switch (triggerType) {
                    case AFTER_DELETE: {
                        this.container.afterDelete((Object)oldBean);
                        return;
                    }
                    case BEFORE_DELETE: {
                        this.container.beforeDelete((Object)oldBean);
                        return;
                    }
                    case AFTER_INSERT: {
                        this.container.afterInsert((Object)newBean);
                        return;
                    }
                    case BEFORE_INSERT: {
                        this.container.beforeInsert((Object)newBean);
                        return;
                    }
                    case AFTER_UPDATE: {
                        this.container.afterUpdate((Object)oldBean);
                        return;
                    }
                    case BEFORE_UPDATE: {
                        this.container.beforeUpdate((Object)newBean);
                        return;
                    }
                    default: {
                        throw new IllegalArgumentException("UNSUPPORTED TriggerType " + triggerType.toString());
                    }
                }
            }
            catch (Exception e) {
                logger.info(e.getMessage(), (Throwable)e);
                return;
            }
            finally {
                this.container.clearFirer();
            }
        }

        public void onSubscribe(final String t) throws SmqUnsubscribeException {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    TableObserverChannel.this.doOnSubscribe(t);
                }
            });
        }

        public boolean registerListener(TableListener<BaseBean> listener) {
            return this.container.add(listener);
        }

        public boolean remove(TableListener<BaseBean> listener) {
            return this.container.remove(listener);
        }
    }
}

