/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.observer;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import gu.simplemq.ISubscriber;
import gu.sql2java.BaseBean;
import gu.sql2java.BaseTableManager;
import gu.sql2java.ListenerContainer;
import gu.sql2java.Managers;
import gu.sql2java.SimpleLog;
import gu.sql2java.observer.JDBCUtility;
import gu.sql2java.observer.RowObserver;

public class RowObservers {
    public static void bindSql2javaTables(RowObserver observer, String dbhostname, String ... tables) {
        Preconditions.checkArgument((null != observer ? 1 : 0) != 0, (Object)"observer is null");
        if (null != tables) {
            for (String tablename : tables) {
                if (Strings.isNullOrEmpty((String)tablename)) continue;
                BaseTableManager m = Managers.getBaseTableManager((String)tablename);
                String schema = JDBCUtility.parseSchemaFromJDBCURL((String)m.getDataSourceConfig().getJdbcUrl());
                String qualifiedName = schema + "." + tablename;
                if (null != dbhostname) {
                    qualifiedName = dbhostname + "/" + qualifiedName;
                }
                SimpleLog.log((String)"row observer register table {}  ", (Object[])new Object[]{qualifiedName});
                observer.register(qualifiedName, (ListenerContainer<BaseBean>)m.getListenerContainer());
            }
        }
    }

    public static RowObserver bindSql2javaTables(ISubscriber subscriber, String dbhostname, String ... tables) {
        RowObserver observer = new RowObserver(subscriber);
        RowObservers.bindSql2javaTables(observer, dbhostname, tables);
        return observer;
    }
}

