/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.observer;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import gu.sql2java.RowMetaData;
import gu.sql2java.exception.RuntimeDaoException;
import gu.sql2java.observer.JDBCUtility;
import gu.sql2java.velocity.Sql2javaClasspathResourceLoader;
import gu.sql2java.velocity.TemplateGenerator;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.velocity.VelocityContext;

public class TriggerGenerator {
    private final ConcurrentHashMap<String, List<String>> columnNames = new ConcurrentHashMap();
    private String dbprefix = null;
    private DatabaseMetaData meta;
    private String catalog;

    public TriggerGenerator() {
        this.init();
    }

    public TriggerGenerator(Connection connection) {
        this();
        this.setConnection(connection);
    }

    public TriggerGenerator(DatabaseMetaData meta) {
        this();
        this.setDatabaseMetaData((DatabaseMetaData)Preconditions.checkNotNull((Object)meta, (Object)"meta is null"));
    }

    private void init() {
        Properties vprops = new Properties();
        vprops.put("directive.set.null.allowed", "true");
        vprops.put("input.encoding", "UTF-8");
        vprops.put("output.encoding", "UTF-8");
        vprops.put("velocimacro.library", "macros.include.vm");
        vprops.put("resource.loader", "class");
        vprops.put("class.resource.loader.description", "Velocity Classpath Resource Loader");
        vprops.put("class.resource.loader.class", Sql2javaClasspathResourceLoader.class.getName());
        vprops.put("class.resource.loader.prefix", "/templates/velocity/ro_notify/includes,/templates/velocity/ro_notify");
        TemplateGenerator.init((Properties)vprops);
    }

    private VelocityContext createConext(String schematable, List<String> columnNames, Properties properties) {
        String tablename = JDBCUtility.parseTablenme((String)schematable);
        VelocityContext context = new VelocityContext();
        context.put("schematable", (Object)schematable);
        context.put("tablename", (Object)tablename);
        context.put("columnNames", columnNames);
        if (null != properties) {
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                context.put(key, properties.get(key));
            }
        }
        return context;
    }

    private List<String> onAbsentByJDBC(String schematable) {
        if (null != this.meta) {
            Pattern p = Pattern.compile("^(\\w+)\\.(\\w+)$");
            Matcher m = p.matcher((CharSequence)Preconditions.checkNotNull((Object)schematable, (Object)"schematable"));
            Preconditions.checkArgument((boolean)m.find(), (Object)"INVALID schematable format,${schema}.${tablename} required");
            String schema = m.group(1);
            String tablename = m.group(2);
            try {
                ImmutableList.Builder builder = ImmutableList.builder();
                ResultSet resultSet = ((DatabaseMetaData)Preconditions.checkNotNull((Object)this.meta, (Object)"meta is uninitialized")).getColumns(this.catalog, schema, tablename, "%");
                while (resultSet.next()) {
                    String column = resultSet.getString("COLUMN_NAME");
                    builder.add((Object)column);
                }
                resultSet.close();
                return builder.build();
            }
            catch (SQLException e) {
                throw new RuntimeDaoException((Throwable)e);
            }
        }
        return null;
    }

    private List<String> onAbsentByMetadata(String schematable) {
        try {
            String tablename = JDBCUtility.parseTablenme((String)schematable);
            RowMetaData rowMetaData = RowMetaData.getMetaData((String)tablename);
            return rowMetaData.columnNames;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected List<String> onAbsent(String schematable) {
        List<String> names = this.onAbsentByJDBC(schematable);
        if (null != names) {
            return names;
        }
        return this.onAbsentByMetadata(schematable);
    }

    public TriggerGenerator setColumnNames(String schematable, List<String> columnNames) {
        this.columnNames.put((String)Preconditions.checkNotNull((Object)schematable, (Object)"schematable is null"), (List<String>)Preconditions.checkNotNull(columnNames, (Object)"columnNames is null"));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getColumnNames(String schematable) {
        List<String> names = this.columnNames.get(schematable);
        if (null == names) {
            ConcurrentHashMap<String, List<String>> concurrentHashMap = this.columnNames;
            synchronized (concurrentHashMap) {
                names = this.onAbsent(schematable);
                if (names != null) {
                    this.columnNames.put(schematable, names);
                }
            }
        }
        return (List)Preconditions.checkNotNull(this.columnNames.get(schematable), (String)"FAIL TO get column names for %s", (Object)schematable);
    }

    public TriggerGenerator setDbprefix(String dbprefix) {
        Preconditions.checkArgument((null == dbprefix || "mysql".equals(dbprefix) ? 1 : 0) != 0, (String)"UNSUPPORTE dbprefix %s,for dbprefix,only 'mysql' supported", (Object)dbprefix);
        this.dbprefix = dbprefix;
        return this;
    }

    private String getDbprefix() {
        return (String)MoreObjects.firstNonNull((Object)this.dbprefix, (Object)"mysql");
    }

    public TriggerGenerator setConnection(Connection connection) {
        try {
            this.meta = ((Connection)Preconditions.checkNotNull((Object)connection, (Object)"connection is null")).getMetaData();
        }
        catch (SQLException e) {
            throw new RuntimeDaoException((Throwable)e);
        }
        return this;
    }

    public TriggerGenerator setDatabaseMetaData(DatabaseMetaData meta) {
        this.meta = meta;
        return this;
    }

    public TriggerGenerator setCatalog(String catalog) {
        this.catalog = catalog;
        return this;
    }

    public String generateTriggerSQL(String schematable, Properties properties, boolean install) {
        VelocityContext context = this.createConext(schematable, install ? this.getColumnNames(schematable) : null, properties);
        return TemplateGenerator.generateString((VelocityContext)context, (String)((String)Preconditions.checkNotNull((Object)this.getDbprefix(), (Object)"dbproduct is null") + (install ? "/install_ro_notify_trigger.sql.vm" : "/remove_ro_notify_trigger.sql.vm")));
    }

    public void generateTriggerSQLFile(String schematable, String filename, Properties properties, boolean install) throws IOException {
        VelocityContext context = this.createConext(schematable, install ? this.getColumnNames(schematable) : null, properties);
        TemplateGenerator.generateFile((VelocityContext)context, (String)((String)Preconditions.checkNotNull((Object)this.getDbprefix(), (Object)"dbproduct is null") + (install ? "/install_ro_notify_trigger.sql.vm" : "/remove_ro_notify_trigger.sql.vm")), (String)filename);
    }
}

