/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.observer;

import com.google.common.base.Preconditions;
import gu.sql2java.IDataSourceConfig;
import gu.sql2java.SimpleLog;
import gu.sql2java.exception.RuntimeDaoException;
import gu.sql2java.observer.JDBCUtility;
import gu.sql2java.observer.TriggerGenerator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public class TriggerInstaller {
    private boolean debug = false;

    public TriggerInstaller() {
        this(false);
    }

    public TriggerInstaller(boolean debug) {
        this.debug = debug;
    }

    private void generateTriggerAndRun(TriggerGenerator triggerGenerator, String schematable, String url, String user, String password, boolean install) {
        SimpleLog.log((String)"{} trigger for {}", (Object[])new Object[]{install ? "install" : "remove", schematable});
        Properties properties = new Properties();
        properties.put("delimiter", (Object)false);
        Connection connection = null;
        try {
            if (null == triggerGenerator) {
                try {
                    connection = JDBCUtility.createConnection((String)url, (String)user, (String)password, null);
                    triggerGenerator = new TriggerGenerator(connection);
                }
                catch (SQLException e) {
                    throw new RuntimeDaoException((Throwable)e);
                }
            }
            String sql = triggerGenerator.generateTriggerSQL((String)Preconditions.checkNotNull((Object)schematable, (Object)"schematable is null"), properties, install);
            JDBCUtility.runMultiSQL((String)sql, (String)url, (String)user, (String)password, (boolean)this.debug);
        }
        catch (SQLException e) {
            throw new RuntimeDaoException((Throwable)e);
        }
        finally {
            if (null != connection) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    throw new RuntimeDaoException((Throwable)e);
                }
            }
        }
    }

    public void installTrigger(TriggerGenerator triggerGenerator, String schematable, String url, String user, String password) throws SQLException {
        this.generateTriggerAndRun((TriggerGenerator)Preconditions.checkNotNull((Object)triggerGenerator, (Object)"triggerGenerator is null"), schematable, url, user, password, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installTrigger(String schematable, String url, String user, String password, String dbprefix) throws SQLException {
        Connection connection = null;
        try {
            connection = JDBCUtility.createConnection((String)url, (String)user, (String)password, null);
            TriggerGenerator triggerGenerator = new TriggerGenerator(connection).setDbprefix(dbprefix);
            this.generateTriggerAndRun(triggerGenerator, schematable, url, user, password, true);
        }
        finally {
            if (null != connection) {
                connection.close();
            }
        }
    }

    public void installTrigger(String tablename, IDataSourceConfig config) {
        Preconditions.checkArgument((null != config ? 1 : 0) != 0, (Object)"config is null");
        String schema = JDBCUtility.parseSchemaFromJDBCURL((String)config.getJdbcUrl());
        this.generateTriggerAndRun(new TriggerGenerator(), schema + "." + tablename, config.getJdbcUrl(), config.getJdbcUsername(), config.getJdbcPassword(), true);
    }

    public void removeTrigger(String schematable, String url, String user, String password, String dbprefix) {
        TriggerGenerator triggerGenerator = new TriggerGenerator().setDbprefix(dbprefix);
        this.generateTriggerAndRun(triggerGenerator, schematable, url, user, password, false);
    }

    public void removeTrigger(String tablename, IDataSourceConfig config) {
        Preconditions.checkArgument((null != config ? 1 : 0) != 0, (Object)"config is null");
        String schema = JDBCUtility.parseSchemaFromJDBCURL((String)config.getJdbcUrl());
        this.generateTriggerAndRun(null, schema + "." + tablename, config.getJdbcUrl(), config.getJdbcUsername(), config.getJdbcPassword(), false);
    }

    private void generateUDFAndRun(String url, String user, String password, boolean install) {
        try {
            SimpleLog.log((String)"{} ro_nofity UDF", (Object[])new Object[]{install ? "install" : "remove"});
            String drop = "DROP FUNCTION IF EXISTS ro_notify;\nDROP FUNCTION IF EXISTS ro_config;\n";
            String create = "CREATE FUNCTION  ro_notify RETURNS INTEGER SONAME 'mysql_observer';\nCREATE FUNCTION  ro_config RETURNS INTEGER SONAME 'mysql_observer';\n";
            String sql = install ? drop + create : drop;
            JDBCUtility.runMultiSQL((String)sql, (String)url, (String)user, (String)password, (boolean)this.debug);
        }
        catch (SQLException e) {
            throw new RuntimeDaoException((Throwable)e);
        }
    }

    public void installUDF(String url, String user, String password) {
        this.generateUDFAndRun(url, user, password, true);
    }

    public void installUDF(IDataSourceConfig config) {
        Preconditions.checkArgument((null != config ? 1 : 0) != 0, (Object)"config is null");
        this.generateUDFAndRun(config.getJdbcUrl(), config.getJdbcUsername(), config.getJdbcPassword(), true);
    }

    public void removeUDF(String url, String user, String password) {
        this.generateUDFAndRun(url, user, password, false);
    }

    public void removeUDF(IDataSourceConfig config) {
        Preconditions.checkArgument((null != config ? 1 : 0) != 0, (Object)"config is null");
        this.generateUDFAndRun(config.getJdbcUrl(), config.getJdbcUsername(), config.getJdbcPassword(), false);
    }
}

