package gu.sql2java.pagehelper.aspect;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gu.sql2java.pagehelper.aspect.spring.PageHelperAop;
/**
 * PagerHelper,WhereHelper 切入点默认实现
 * @author guyadong
 *
 */
@Component
@Aspect
public class PageHelperDefaultAround {
	@Autowired
	private PageHelperAop pageHelperAop;
    /**
     * 分页查询aspect实现
     */
    @Around("(whereHelperAnnotation() ||pageHelperAnnotation()) && excelRestControllerAspect()")
	public Object excelAroundDefault(ProceedingJoinPoint joinPoint) throws Throwable {
		return pageHelperAop.pageHelperAround(joinPoint);
	}
	/**
	 * 定义切入点为有注解{@link org.springframework.web.bind.annotation.RestController}下的所有类
	 */
	@Pointcut("@within(org.springframework.web.bind.annotation.RestController)")
	public void excelRestControllerAspect() {
	}
	
    /**
     * 定义切入点为有{@link gu.sql2java.pagehelper.annotations.Sql2javaEnablePage}注解的所有函数
     */
    @Pointcut("@annotation(gu.sql2java.pagehelper.annotations.Sql2javaEnablePage)")
    public void pageHelperAnnotation() {
    }
    /**
     * 定义切入点为有{@link gu.sql2java.wherehelper.annotations.EnableWhereHelper}注解的所有函数
     */
    @Pointcut("@annotation(gu.sql2java.wherehelper.annotations.EnableWhereHelper)")
    public void whereHelperAnnotation() {
    }

}
