package gu.sql2java.wherehelper.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import gu.sql2java.BaseRow;

import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.ElementType;

/**
 * sql2java WhereHelper启动注解
 * @author guyadong
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD,ElementType.TYPE})
@Documented
public @interface EnableWhereHelper {
	/**
	 * SELECT ${column} FROM ${table} 语句
	 */
	String value() default "";
	/**
	 * 为{@code true}启用WhereHelper
	 */
	boolean enable() default true;
	/**
	 * 表达式之间的逻辑操作连接符AND 或 OR,默认AND
	 */
	String logicOperator() default "AND";
	/**
	 * 为{@code true}输出调试信息
	 */
	boolean debuglog() default false;
	/**
	 *  输入参数的目标表对象,默认为 {@link BaseRow} ,
	 *  如果只是简单的单表查询,且变量命名都是字段名,就在此定义表记录类型，
	 *  以方便WhereHelper准确识别字段类型
	 */
	Class<? extends BaseRow> targetClass() default BaseRow.class;

	/**
	 * 变量名列表,与varTypeValues一起定义变量类型,
	 * 对于非String类型字段和Number类型的字段需要在此定义类型
	 * 
	 */
	String[] varTypeKeys() default {};
	/**
	 * 与varTypeKeys一起定义变量名的类型,长度必须与varTypeKeys一样,
	 * 数组中的每个元素是varTypeKeys对应索引位置的变量名的类型
	 */
	Class<?>[]varTypeValues() default {};
	
}