package gu.sql2java.wherehelper.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;

/**
 * WhereHelper 等价表达式注解
 * @author guyadong
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD,ElementType.TYPE})
@Documented
@Repeatable(Equals.class)
public @interface Equal{
	/**
	 * 等价比较的字段名
	 */
	String value() default "";
	/**
	 * 为{@code true} 不检查字段参数是否为{@code null}或空
	 */
	boolean notCheckEmpty() default false;
	/**
	 * 为{@code true}执行不等价比较
	 */
	boolean not() default false;
}
