package gu.sql2java.wherehelper.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;

/**
 * WhereHelper 条件等价表达式注解
 * @author guyadong
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD,ElementType.TYPE})
@Documented
@Repeatable(EqualIfs.class)
public @interface EqualIf{
	/**
	 * test表达式执行为true时执行的表达式
	 */
	String test() default "";
	/**
	 * 等价比较的字段名
	 */
	String field() default "";
	/**
	 * 为{@code true}执行不等价比较
	 */
	boolean not() default false;
}
