package gu.sql2java.wherehelper.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;

/**
 * WhereHelper if ... else ... 条件表达式注解
 * @author guyadong
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD,ElementType.TYPE})
@Documented
@Repeatable(IfElses.class)
public @interface IfElse {
	/**
	 * BeanShell 条件判断表达式,表达执行为{@code true}时,执行{@link #doStatement()}定义的语句,否则执行{@link #elseStatement()}定义的语句
	 */
	String test() default " true ";
	/**
	 * test表达式执行为true时执行的表达式
	 */
	String doStatement() default "";
	/**
	 * test表达式执行为false时执行的表达式
	 */
	String elseStatement() default "";
}
