package gu.sql2java.wherehelper.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.ElementType;

/**
 * WhereHelper ORDER BY 表达式注解
 * @author guyadong
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD,ElementType.TYPE})
@Documented
public @interface OrderBy {
	/**
	 * ORDER BY 字段列表,格式 ${column} [ASC|DESC]<br>
	 * 如:
	 * <pre>
	 * 'name' DESC
	 * 'date' 
	 * </pre>
	 */
	String[] value() default {};
	/**
	 * ORDER BY 字段变量名,用于应用层(前端)定义ORDER BY 字段名的变量名定义
	 */
	String orderByVarname() default "orderBy";
}
