/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.pagehelper.aspect.spring;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import gu.sql2java.SimpleLog;
import gu.sql2java.pagehelper.PageHelper;
import gu.sql2java.pagehelper.annotations.Sql2javaEnablePage;
import gu.sql2java.wherehelper.WhereHelper;
import gu.sql2java.wherehelper.WhereHelpers;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class PageHelperAop {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pageHelperAround(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        Sql2javaEnablePage enablePage = method.getAnnotation(Sql2javaEnablePage.class);
        if (null == enablePage || !enablePage.value() || Strings.isNullOrEmpty((String)enablePage.pageNumKey()) || Strings.isNullOrEmpty((String)enablePage.pageSizeKey())) {
            PageHelper.setEnable((boolean)false);
            PageHelperAop.buildWhereHelperIfEnable(joinPoint);
            try {
                Object object = joinPoint.proceed();
                return object;
            }
            finally {
                PageHelper.clearPage();
            }
        }
        boolean startPage = false;
        try {
            String pageNumKey = enablePage.pageNumKey();
            String pageSizeKey = enablePage.pageSizeKey();
            String countKey = enablePage.countKey();
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String pageNum = (String)MoreObjects.firstNonNull((Object)request.getParameter(pageNumKey), (Object)"1");
            String pageSize = (String)MoreObjects.firstNonNull((Object)request.getParameter(pageSizeKey), (Object)"10");
            if (!Strings.isNullOrEmpty((String)pageNum) && !Strings.isNullOrEmpty((String)pageSize)) {
                String count;
                boolean docount = true;
                if (!Strings.isNullOrEmpty((String)countKey) && null != (count = request.getParameter(countKey))) {
                    docount = Boolean.valueOf(count);
                }
                PageHelper.startPage((int)Integer.valueOf(pageNum), (int)Integer.valueOf(pageSize), (boolean)docount);
            }
            PageHelperAop.buildWhereHelperIfEnable(joinPoint);
            startPage = true;
        }
        catch (Exception e) {
            SimpleLog.log((Throwable)e);
        }
        finally {
            if (!startPage) {
                PageHelper.clearPage();
            }
        }
        try {
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            PageHelper.clearPage();
        }
    }

    private static void buildWhereHelperIfEnable(ProceedingJoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        WhereHelper whereHelper = WhereHelpers.buildWhereHelperIfEnable(method, joinPoint.getArgs(), (Function<String, String>)((Function)arg_0 -> ((HttpServletRequest)request).getParameter(arg_0)));
        if (null != whereHelper) {
            PageHelper.setWhere((String)whereHelper.where());
        }
    }
}

