/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.wherehelper;

import bsh.EvalError;
import bsh.Interpreter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import gu.sql2java.BaseRow;
import gu.sql2java.RowMetaData;
import gu.sql2java.SimpleLog;
import gu.sql2java.bean.BeanPropertyUtils;
import gu.sql2java.wherehelper.BeanShellWhereBuilder;
import gu.sql2java.wherehelper.WhereHelpers;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;

public class WhereHelper {
    public static final String TIMESTAMP_FORMATTER_STR = "yyyy-MM-dd HH:mm:ss";
    public static final String VAR_ORDER_BY_COLUMN = "order_by_column";
    public static final String VAR_GROUP_BY_COLUMN = "group_by_column";
    public static final String VAR_LIMIT_ROW_COUNT = "limit_row_count";
    public static final String VAR_LIMIT_OFFSET = "limit_offset";
    private static final String KEYWORD_BSH = "bsh";
    private static final Set<String> KEYWORDS = ImmutableSet.builder().add((Object)"bsh").add((Object)"cond_count").add((Object)"where_buffer").add((Object)"cond_buffer").build();
    private static final HashSet<String> BUILTIN_VARS = Sets.newHashSet((Object[])new String[]{"limit_row_count", "limit_offset"});
    private Interpreter interpreter = new Interpreter();
    private String timeFormatter = "yyyy-MM-dd HH:mm:ss";
    PropertyUtilsBean propertyUtils = BeanUtilsBean.getInstance().getPropertyUtils();
    private final String bshScript;
    private boolean debuglog = false;
    private Set<String> referenceVariables = Collections.emptySet();
    private Class<? extends BaseRow> targetClass = BaseRow.class;
    private Map<String, Class<?>> varTypes = Collections.emptyMap();
    private String defaultOrderByColumns;
    private String defaultGroupByColumns;
    private String orderByVar;
    private String groupByVar;

    public WhereHelper(String bshScript) {
        this.bshScript = (String)Preconditions.checkNotNull((Object)bshScript, (Object)"bshScript is null");
        this.interpreter.getNameSpace().importObject((Object)this);
    }

    WhereHelper(BeanShellWhereBuilder builder) {
        this(((BeanShellWhereBuilder)Preconditions.checkNotNull((Object)builder, (Object)"bshScript is null")).buildScript());
        this.referenceVariables = builder.getReferenceVariables();
        this.targetClass = builder.getTargetClass();
        this.varTypes = builder.getVarTypes();
        this.debuglog = builder.debuglog();
        this.defaultOrderByColumns = builder.getOrderByColumns();
        this.defaultGroupByColumns = builder.getGroupByColumns();
        this.orderByVar = builder.getOrderByVarname();
        this.groupByVar = builder.getGroupByVarname();
    }

    public WhereHelper timeFormatter(String timeFormatter) {
        if (!Strings.isNullOrEmpty((String)timeFormatter)) {
            this.timeFormatter = timeFormatter;
        }
        return this;
    }

    public WhereHelper defineVariable(String varname, Object value) {
        if (!Strings.isNullOrEmpty((String)varname)) {
            try {
                value = WhereHelper.guess(value);
                this.interpreter.set(varname, value);
                SimpleLog.log((boolean)this.debuglog, (String)"{} = {}", (Object[])new Object[]{varname, value});
            }
            catch (EvalError e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public WhereHelper with(Object params) {
        this.initVars(Preconditions.checkNotNull((Object)params, (Object)"params is null"));
        return this;
    }

    public WhereHelper with(Function<String, String> valueSupplier) {
        if (null != valueSupplier) {
            this.referenceVariables.forEach(varname -> {
                String v = (String)valueSupplier.apply(varname);
                if (null == v) {
                    if (WhereHelpers.isCamelcase(varname)) {
                        v = (String)valueSupplier.apply((Object)WhereHelpers.toSnakecase(varname));
                    } else if (WhereHelpers.isSnakelcase(varname)) {
                        v = (String)valueSupplier.apply((Object)WhereHelpers.toCamelcase(varname));
                    }
                }
                if (null == v) {
                    this.defineVariable((String)varname, v);
                } else {
                    Class<?> varType = this.variableTypeOf((String)varname);
                    if (null == varType) {
                        this.defineVariable((String)varname, v);
                    } else if (String.class == varType) {
                        this.defineVariable((String)varname, v);
                    } else {
                        this.defineVariable((String)varname, JSON.parseObject((String)v, varType, (ParserConfig)ParserConfig.global, null, (int)0, (Feature[])new Feature[0]));
                    }
                }
            });
        }
        return this;
    }

    public String where() {
        try {
            this.beforeWhere();
            StringBuffer buffer = new StringBuffer();
            this.interpreter.set("where_buffer", (Object)buffer);
            this.interpreter.eval(this.bshScript);
            this.unsetVars();
            String where = buffer.toString();
            SimpleLog.log((boolean)this.debuglog, (String)"{}", (Object[])new Object[]{where});
            return where;
        }
        catch (EvalError e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isEmpty(Object value) {
        return BeanPropertyUtils.isEmpty(value);
    }

    public boolean isTrue(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return 0 != ((Number)value).intValue();
        }
        return null != value && value.toString().toLowerCase().matches("true|on|1|y(es)?");
    }

    public boolean isFalse(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if (value instanceof Number) {
            return 0 == ((Number)value).intValue();
        }
        return null != value && value.toString().toLowerCase().matches("false|off|0|no?");
    }

    public String op(String field, boolean not) {
        if (!Strings.isNullOrEmpty((String)field)) {
            try {
                return field + " " + this.asCond(this.interpreter.get(field), not);
            }
            catch (EvalError e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String op(String field) {
        return this.op(field, false);
    }

    private void appendValue(StringBuilder result, Object value) {
        if (null == value) {
            result.append("NULL");
        } else if (value.getClass().isArray() && 1 == Array.getLength(value)) {
            this.appendValue(result, Array.get(value, 0));
        } else if (value instanceof boolean[]) {
            this.appendInBraces(result, Arrays.toString((boolean[])value));
        } else if (value instanceof byte[]) {
            this.appendInBraces(result, Arrays.toString((byte[])value));
        } else if (value instanceof short[]) {
            this.appendInBraces(result, Arrays.toString((short[])value));
        } else if (value instanceof int[]) {
            this.appendInBraces(result, Arrays.toString((int[])value));
        } else if (value instanceof long[]) {
            this.appendInBraces(result, Arrays.toString((long[])value));
        } else if (value instanceof float[]) {
            this.appendInBraces(result, Arrays.toString((float[])value));
        } else if (value instanceof double[]) {
            this.appendInBraces(result, Arrays.toString((double[])value));
        } else if (value instanceof char[]) {
            this.appendInBraces(result, Arrays.toString((char[])value));
        } else if (value instanceof Object[]) {
            result.append('(');
            int c = 0;
            for (Object v : (Object[])value) {
                if (c++ > 0) {
                    result.append(',');
                }
                this.appendValue(result, v);
            }
            result.append(')');
        } else if (value instanceof Iterator) {
            result.append('(');
            int c = 0;
            Iterator itor = (Iterator)value;
            while (itor.hasNext()) {
                if (c++ > 0) {
                    result.append(',');
                }
                this.appendValue(result, itor.next());
            }
            result.append(')');
        } else if (value instanceof Iterable) {
            this.appendValue(result, ((Iterable)value).iterator());
        } else if (value instanceof String) {
            result.append("'").append(value).append("'");
        } else if (value instanceof Date) {
            result.append("'").append(new SimpleDateFormat(this.timeFormatter).format((Date)value)).append("'");
        } else {
            result.append(value);
        }
    }

    private void appendInBraces(StringBuilder buf, String s) {
        buf.append('(').append(s.substring(1, s.length() - 1)).append(')');
    }

    private String stringOf(Object value) {
        StringBuilder builder = new StringBuilder();
        this.appendValue(builder, value);
        return builder.toString();
    }

    public String asCond(Object value, boolean not) {
        if (null == value) {
            return "IS " + (not ? "NOT " : "") + "NULL";
        }
        if (value instanceof Iterable || value instanceof Iterator || value.getClass().isArray()) {
            return String.format("%sIN %s", not ? "NOT " : "", this.stringOf(value));
        }
        return String.format("%s= %s", not ? "!" : "", this.stringOf(value));
    }

    private Object valueOf(Object obj, String field) {
        try {
            return this.propertyUtils.getProperty(obj, field);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    private void initVarIfNotdefined(String varname, Object defaultValue, boolean camelCase) throws EvalError {
        String camelCaseName;
        if (null == this.interpreter.get(varname)) {
            this.interpreter.set(varname, defaultValue);
        } else if (camelCase && !(camelCaseName = WhereHelpers.toCamelcase(varname)).equals(varname)) {
            this.interpreter.set(camelCaseName, this.interpreter.get(varname));
        }
    }

    private String isRefVar(String varname) {
        if (this.referenceVariables.contains(varname)) {
            return varname;
        }
        String v = WhereHelpers.toCamelcase(varname);
        if (this.referenceVariables.contains(v)) {
            return v;
        }
        v = WhereHelpers.toSnakecase(varname);
        if (this.referenceVariables.contains(v)) {
            return v;
        }
        return null;
    }

    private void initVars(Object params) {
        try {
            if (params instanceof Map) {
                Map m = (Map)params;
                for (Map.Entry entry : m.entrySet()) {
                    String refVar;
                    if (!(entry.getKey() instanceof String) || null == (refVar = this.isRefVar((String)entry.getKey()))) continue;
                    Object value = entry.getValue();
                    this.interpreter.set(WhereHelper.checkVarName(refVar), value);
                    SimpleLog.log((boolean)this.debuglog, (String)"variable {}={}", (Object[])new Object[]{refVar, value});
                }
            } else {
                Map<String, PropertyDescriptor> props = BeanPropertyUtils.getProperties(params.getClass(), 3, true);
                for (String field : props.keySet()) {
                    String refVar = this.isRefVar(field);
                    if (null == refVar) continue;
                    Object value = this.valueOf(params, field);
                    this.interpreter.set(WhereHelper.checkVarName(refVar), value);
                    SimpleLog.log((boolean)this.debuglog, (String)"variable {}={}", (Object[])new Object[]{refVar, value});
                }
            }
        }
        catch (EvalError e) {
            throw new RuntimeException(e);
        }
    }

    private void beforeWhere() throws EvalError {
        for (String varname : BUILTIN_VARS) {
            this.initVarIfNotdefined(varname, null, true);
        }
        this.initVarIfNotdefined(this.orderByVar, this.defaultOrderByColumns, false);
        this.initVarIfNotdefined(this.groupByVar, this.defaultGroupByColumns, false);
    }

    private void unsetVars() throws EvalError {
        for (String varname : Arrays.asList(this.interpreter.getNameSpace().getVariableNames())) {
            if (KEYWORD_BSH.equals(varname)) continue;
            SimpleLog.log((boolean)this.debuglog, (String)"unset {}", (Object[])new Object[]{varname});
            this.interpreter.unset(varname);
        }
    }

    private Class<?> variableTypeOf(String varname) {
        if (!Strings.isNullOrEmpty((String)varname)) {
            RowMetaData metaData = RowMetaData.getMetaDataUnchecked(this.targetClass);
            if (null != metaData) {
                Class type = metaData.columnTypeOf(varname);
                if (null != type) {
                    return type;
                }
                return metaData.columnTypeOf(WhereHelpers.toCamelcase(varname));
            }
            Class<?> type = this.varTypes.get(varname);
            if (null != type) {
                return type;
            }
            if (WhereHelpers.isCamelcase(varname)) {
                return this.varTypes.get(WhereHelpers.toSnakecase(varname));
            }
            if (WhereHelpers.isSnakelcase(varname)) {
                return this.varTypes.get(WhereHelpers.toCamelcase(varname));
            }
        }
        return null;
    }

    private static Object guess(Object obj) {
        String value;
        if (obj instanceof String && !Strings.isNullOrEmpty((String)(value = (String)obj)) && value.trim().startsWith("[")) {
            try {
                return JSON.parseObject((String)value, JSONArray.class, (ParserConfig)ParserConfig.global, null, (int)0, (Feature[])new Feature[0]);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return obj;
    }

    private static String checkVarName(String varname) {
        Preconditions.checkArgument((!KEYWORDS.contains(varname) ? 1 : 0) != 0, (String)"'%s' must not be a variable name,because it is protected keyword of WhereHelper or BeanShell", (Object)varname);
        return varname;
    }

    public static BeanShellWhereBuilder builder() {
        return new BeanShellWhereBuilder();
    }

    public String toString() {
        return "WhereHelper [" + (this.timeFormatter != null ? "timeFormatter=" + this.timeFormatter + ", " : "") + (this.bshScript != null ? "script=" + this.bshScript : "") + "]";
    }
}

