/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.bean;

import gu.sql2java.bean.LenientDecoratorOfDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;

public class BeanPropertyUtils {
    private static final boolean hasReadMethod(PropertyDescriptor propertyDescriptor) {
        Method m = propertyDescriptor.getReadMethod();
        return m != null && m.getDeclaringClass() != Object.class;
    }

    private static final boolean hasWriteMethod(PropertyDescriptor propertyDescriptor) {
        Method m = propertyDescriptor.getWriteMethod();
        return m != null && m.getDeclaringClass() != Object.class;
    }

    public static final Map<String, PropertyDescriptor> getProperties(Class<?> beanClass, int rw, boolean lenient) {
        try {
            HashMap<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
            if (beanClass != null) {
                PropertyDescriptor[] origDescriptors;
                BeanUtilsBean beanUtils = BeanUtilsBean.getInstance();
                PropertyUtilsBean propertyUtils = beanUtils.getPropertyUtils();
                for (PropertyDescriptor pd : origDescriptors = propertyUtils.getPropertyDescriptors(beanClass)) {
                    if (lenient) {
                        pd = LenientDecoratorOfDescriptor.toDecorator(pd);
                    }
                    Boolean put = false;
                    switch (rw &= 3) {
                        case 0: {
                            put = BeanPropertyUtils.hasReadMethod(pd) || BeanPropertyUtils.hasWriteMethod(pd);
                            break;
                        }
                        case 1: {
                            put = BeanPropertyUtils.hasWriteMethod(pd);
                            break;
                        }
                        case 2: {
                            put = BeanPropertyUtils.hasReadMethod(pd);
                            break;
                        }
                        case 3: {
                            put = BeanPropertyUtils.hasReadMethod(pd) && BeanPropertyUtils.hasWriteMethod(pd);
                        }
                    }
                    if (!put.booleanValue()) continue;
                    properties.put(pd.getName(), pd);
                }
            }
            return properties;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final Map<String, PropertyDescriptor> getProperties(Class<?> beanClass, int rw) {
        return BeanPropertyUtils.getProperties(beanClass, rw, false);
    }

    public static final <T> T copy(T from, T to) {
        if (null == from || null == to) {
            throw new NullPointerException();
        }
        PropertyUtilsBean propertyUtils = BeanUtilsBean.getInstance().getPropertyUtils();
        try {
            propertyUtils.copyProperties(to, from);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return to;
    }

    public static final void copyBean(Object from, Object to, boolean ignoreNull, boolean ignoreEmpty) {
        if (null == from || null == to) {
            throw new NullPointerException("from or to is null");
        }
        Map<String, PropertyDescriptor> fromProps = BeanPropertyUtils.getProperties(from.getClass(), 1);
        Map<String, PropertyDescriptor> toProps = BeanPropertyUtils.getProperties(to.getClass(), 2);
        HashSet<String> intersection = new HashSet<String>(fromProps.keySet());
        intersection.retainAll(toProps.keySet());
        PropertyUtilsBean propertyUtils = BeanUtilsBean.getInstance().getPropertyUtils();
        try {
            for (String fieldName : intersection) {
                Object value = propertyUtils.getProperty(from, fieldName);
                if (ignoreNull && null == value || ignoreEmpty && BeanPropertyUtils.isEmpty(value)) continue;
                propertyUtils.setProperty(to, fieldName, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isEmpty(Object value) {
        if (null == value) {
            return true;
        }
        if (value instanceof String) {
            return ((String)value).isEmpty();
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        if (value instanceof Iterator) {
            return !((Iterator)value).hasNext();
        }
        if (value instanceof Iterable) {
            return !((Iterable)value).iterator().hasNext();
        }
        if (value instanceof Map) {
            return ((Map)value).isEmpty();
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) == 0;
        }
        return false;
    }
}

