/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.wherehelper;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import gu.sql2java.BaseRow;
import gu.sql2java.SimpleLog;
import gu.sql2java.wherehelper.WhereHelper;
import gu.sql2java.wherehelper.annotations.EnableWhereHelper;
import gu.sql2java.wherehelper.annotations.Equal;
import gu.sql2java.wherehelper.annotations.EqualIf;
import gu.sql2java.wherehelper.annotations.Expression;
import gu.sql2java.wherehelper.annotations.GroupBy;
import gu.sql2java.wherehelper.annotations.IfElse;
import gu.sql2java.wherehelper.annotations.OrderBy;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BeanShellWhereBuilder {
    private static final String TMPL_EQUAL = "equal.tmpl";
    private static final String TMPL_EQUAL_IF = "equal_if.tmpl";
    private static final String TMPL_IF_ELSE = "if_else.tmpl";
    private static final String TMPL_GROUP_BY = "group_by.tmpl";
    private static final String TMPL_ORDER_BY = "order_by.tmpl";
    private static final String TMPL_EXP = "exp.tmpl";
    private static final String TMPL_LIMIT = "limit.tmpl";
    private static final String TMPL_BEFORE_COND = "before_cond.tmpl";
    private static final String TMPL_AFTER_COND = "after_cond.tmpl";
    private static final String NO_FIRST_CONDITION = "$<NO_FIRST_CONDITION>";
    public static final String NOT_EQUAL = "$<NOT_EQUAL>";
    public static final String IGNORE_EMPTY = "$<IGNORE_EMPTY>";
    private static final String AND_OR = "$<AND_OR>";
    private static final String DEFAULT_ORDER_BY_VAR = "order_by_column";
    private static final String DEFAULT_GROUP_BY_VAR = "group_by_column";
    public static final String KEYWORD_COND_COUNT = "cond_count";
    public static final String KEYWORD_WHERE_BUFFER = "where_buffer";
    public static final String KEYWORD_EXP_BUFFER = "cond_buffer";
    public static final String DT_MYSQL = "MySQL";
    private String selectFrom = "";
    private String andor = "AND";
    private List<String> conditionCodes = Lists.newLinkedList();
    private List<String> orderByColumns = Lists.newLinkedList();
    private List<String> groupByColumns = Lists.newLinkedList();
    private String sqltype = "MySQL";
    private boolean debuglog = false;
    private boolean pagequery = true;
    private Class<? extends BaseRow> targetClass = BaseRow.class;
    private Set<String> referenceVariables;
    private Map<String, Class<?>> varTypes = Collections.emptyMap();
    private String orderByVarname = "order_by_column";
    private String groupByVarname = "group_by_column";

    BeanShellWhereBuilder() {
    }

    public boolean debuglog() {
        return this.debuglog;
    }

    public BeanShellWhereBuilder debuglog(boolean debuglog) {
        this.debuglog = debuglog;
        return this;
    }

    public BeanShellWhereBuilder pagequery(boolean pagequery) {
        this.pagequery = pagequery;
        return this;
    }

    public Set<String> getReferenceVariables() {
        return this.referenceVariables;
    }

    public Class<? extends BaseRow> getTargetClass() {
        return this.targetClass;
    }

    public Map<String, Class<?>> getVarTypes() {
        return this.varTypes;
    }

    public String getOrderByVarname() {
        return this.orderByVarname;
    }

    public String getGroupByVarname() {
        return this.groupByVarname;
    }

    public String getOrderByColumns() {
        return Joiner.on((char)',').join(this.orderByColumns);
    }

    public String getGroupByColumns() {
        return Joiner.on((char)',').join(this.groupByColumns);
    }

    public BeanShellWhereBuilder exp(String exp) {
        if (!Strings.isNullOrEmpty((String)(exp = Strings.nullToEmpty((String)exp).trim()))) {
            this.conditionCodes.add(((String)Tmpls.tmpls.get((Object)TMPL_EXP)).replace(NO_FIRST_CONDITION, "" + !this.conditionCodes.isEmpty()).replace(AND_OR, this.andor).replace("$<exp>", exp));
        }
        return this;
    }

    public BeanShellWhereBuilder or() {
        this.andor = "OR";
        return this;
    }

    public BeanShellWhereBuilder and() {
        this.andor = "AND";
        return this;
    }

    private BeanShellWhereBuilder equal(String field, boolean not, boolean notCheckEmpty) {
        if (!Strings.isNullOrEmpty((String)field)) {
            this.conditionCodes.add(((String)Tmpls.tmpls.get((Object)TMPL_EQUAL)).replace(NO_FIRST_CONDITION, "" + !this.conditionCodes.isEmpty()).replace(NOT_EQUAL, "" + not).replace(IGNORE_EMPTY, "" + notCheckEmpty).replace(AND_OR, this.andor).replace("$<field>", field));
        }
        return this;
    }

    public BeanShellWhereBuilder equal(String field) {
        return this.equal(field, false, true);
    }

    public BeanShellWhereBuilder equalNot(String field) {
        return this.equal(field, true, true);
    }

    public BeanShellWhereBuilder equalIfNonEmpty(String field, boolean not) {
        return this.equal(field, not, false);
    }

    public BeanShellWhereBuilder equalIfNonEmpty(String field) {
        return this.equal(field, false, false);
    }

    public BeanShellWhereBuilder equalIf(String test, String field, boolean not) {
        if (!Strings.isNullOrEmpty((String)test) && !Strings.isNullOrEmpty((String)field)) {
            this.conditionCodes.add(((String)Tmpls.tmpls.get((Object)TMPL_EQUAL_IF)).replace(NOT_EQUAL, "" + not).replace(AND_OR, this.andor).replace("$<TEST>", test).replace("$<field>", field));
        }
        return this;
    }

    public BeanShellWhereBuilder ifelse(String test, String doStatement, String elseStatement) {
        if (!Strings.isNullOrEmpty((String)test) && !Strings.isNullOrEmpty((String)doStatement)) {
            elseStatement = Strings.nullToEmpty((String)elseStatement);
            this.conditionCodes.add(((String)Tmpls.tmpls.get((Object)TMPL_IF_ELSE)).replace(NO_FIRST_CONDITION, "" + !this.conditionCodes.isEmpty()).replace(AND_OR, this.andor).replace("$<TEST>", test).replace("$<THEN>", doStatement).replace("$<ELSE>", elseStatement));
        }
        return this;
    }

    public BeanShellWhereBuilder onlyif(String test, String doStatement) {
        return this.ifelse(test, doStatement, null);
    }

    public BeanShellWhereBuilder selectFrom(String selectFrom) {
        if (!Strings.isNullOrEmpty((String)selectFrom)) {
            this.selectFrom = selectFrom;
        }
        return this;
    }

    public BeanShellWhereBuilder orderBy(String columnName, boolean desc) {
        if (!Strings.isNullOrEmpty((String)(columnName = Strings.nullToEmpty((String)columnName).trim()))) {
            Preconditions.checkArgument((boolean)columnName.matches("('\\w+'|\\w+)"));
            this.orderByColumns.add(columnName + (desc ? " DESC " : ""));
        }
        return this;
    }

    public BeanShellWhereBuilder orderBy(String columnName) {
        if (!Strings.isNullOrEmpty((String)columnName)) {
            this.orderByColumns.add(BeanShellWhereBuilder.validOrderBy(columnName));
        }
        return this;
    }

    public BeanShellWhereBuilder orderByVar(String varName) {
        if (!Strings.isNullOrEmpty((String)varName)) {
            varName = varName.trim();
            Preconditions.checkArgument((boolean)varName.matches("^[_a-zA-Z]\\w*$"), (String)"INVALID variable name [%s]", (Object)varName);
            this.orderByVarname = varName;
        }
        return this;
    }

    public BeanShellWhereBuilder groupBy(String ... columnNames) {
        if (null != columnNames) {
            Iterable normalized = Iterables.transform(Arrays.asList(columnNames), s -> Strings.nullToEmpty((String)s).trim());
            Iterables.addAll(this.groupByColumns, (Iterable)Iterables.filter((Iterable)normalized, s -> !s.isEmpty() && s.matches("\\w+")));
        }
        return this;
    }

    public BeanShellWhereBuilder groupByVar(String varName) {
        if (!Strings.isNullOrEmpty((String)varName)) {
            varName = varName.trim();
            Preconditions.checkArgument((boolean)varName.matches("$[[:alpha:]]\\w?"));
            this.groupByVarname = varName;
        }
        return this;
    }

    public BeanShellWhereBuilder from(Annotation[] annots) {
        if (null != annots) {
            for (Annotation a : annots) {
                Annotation eq;
                if (a.annotationType() == EnableWhereHelper.class) {
                    EnableWhereHelper enableWhereHelper = (EnableWhereHelper)a;
                    this.selectFrom = enableWhereHelper.value();
                    this.debuglog = enableWhereHelper.debuglog();
                    this.andor = BeanShellWhereBuilder.validLogicOperator(enableWhereHelper.logicOperator());
                    this.targetClass = enableWhereHelper.targetClass();
                    this.buildVarTypes(enableWhereHelper);
                    continue;
                }
                if (a.annotationType() == Equal.class) {
                    eq = (Equal)a;
                    this.equal(eq.value(), eq.not(), eq.notCheckEmpty());
                    continue;
                }
                if (a.annotationType() == EqualIf.class) {
                    eq = (EqualIf)a;
                    this.equalIf(eq.test(), eq.field(), eq.not());
                    continue;
                }
                if (a.annotationType() == Expression.class) {
                    Expression exp = (Expression)a;
                    this.exp(exp.value());
                    continue;
                }
                if (a.annotationType() == IfElse.class) {
                    IfElse ifElse = (IfElse)a;
                    this.ifelse(ifElse.test(), ifElse.doStatement(), ifElse.elseStatement());
                    continue;
                }
                if (a.annotationType() == OrderBy.class) {
                    String[] orderBys;
                    OrderBy orderBy = (OrderBy)a;
                    for (String o : orderBys = orderBy.value()) {
                        this.orderBy(o);
                    }
                    this.orderByVar(orderBy.orderByVarname());
                    continue;
                }
                if (a.annotationType() == GroupBy.class) {
                    this.groupBy(((GroupBy)a).value());
                    continue;
                }
                try {
                    Method method = a.annotationType().getMethod("value", new Class[0]);
                    Class<?> returnType = method.getReturnType();
                    if (!returnType.isArray() || !Annotation.class.isAssignableFrom(returnType.getComponentType())) continue;
                    this.from((Annotation[])method.invoke((Object)a, new Object[0]));
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
        }
        return this;
    }

    String buildScript() {
        this.conditionCodes.add(((String)Tmpls.tmpls.get((Object)TMPL_ORDER_BY)).replace("${order_by_column}", "${" + this.orderByVarname + "}"));
        this.conditionCodes.add(((String)Tmpls.tmpls.get((Object)TMPL_GROUP_BY)).replace("${group_by_column}", "${" + this.groupByVarname + "}"));
        if (this.pagequery && DT_MYSQL.equals(this.sqltype)) {
            this.conditionCodes.add((String)Tmpls.tmpls.get((Object)TMPL_LIMIT));
        }
        StringBuffer buffer = new StringBuffer();
        if (!this.selectFrom.isEmpty()) {
            buffer.append(String.format("where_buffer.append(\"%s \");\n", this.selectFrom));
        }
        String script = buffer.append((String)Tmpls.tmpls.get((Object)TMPL_BEFORE_COND)).append(this.extractReferenceVariables(Joiner.on((String)"\n").join(this.conditionCodes))).append((String)Tmpls.tmpls.get((Object)TMPL_AFTER_COND)).toString();
        SimpleLog.log((boolean)this.debuglog, (String)script, (Object[])new Object[0]);
        SimpleLog.log((boolean)this.debuglog, (String)"referenceVariables: {}", (Object[])new Object[]{Iterables.toString(this.referenceVariables)});
        return script;
    }

    private String extractReferenceVariables(String input) {
        this.referenceVariables = Sets.newHashSet();
        if (!Strings.isNullOrEmpty((String)input)) {
            Pattern pattern = Pattern.compile("\\$\\{(\\w+)\\}");
            Matcher matcher = pattern.matcher(input);
            while (matcher.find()) {
                this.referenceVariables.add(matcher.group(1));
            }
            return this.replaceVar(input);
        }
        return input;
    }

    private String replaceVar(String input) {
        Pattern p1 = Pattern.compile("(?<!\\\\)\".*(?<!\\\\)\"");
        Matcher m1 = p1.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (m1.find()) {
            String str = m1.group(0).replaceAll("op\\s*\\(\\s*\\\\\"(\\w+)\\\\\"\\s*\\)", "\"+op(\"$1\")+\"").replaceAll("op\\s*\\(\\s*\\$\\{(\\w+)}\\s*\\)", "\"+op(\"$1\")+\"").replaceAll("\\$\\{(\\w+)}", "\"+$1+\"");
            try {
                m1.appendReplacement(sb, str);
            }
            catch (RuntimeException e) {
                m1.appendReplacement(sb, "$0");
            }
        }
        m1.appendTail(sb);
        return sb.toString().replaceAll("\\$\\{(\\w+)\\}", "$1");
    }

    private void buildVarTypes(EnableWhereHelper annot) {
        Class<?>[] vartypes;
        String[] varnames = annot.varTypeKeys();
        Preconditions.checkArgument((varnames.length == (vartypes = annot.varTypeValues()).length ? 1 : 0) != 0, (Object)"INVALID variable type defined by EnableWhereHelper,array length of varTypeKeys must equal with varTypeValues");
        this.varTypes = Maps.newHashMap();
        for (int i = 0; i < varnames.length; ++i) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)varnames[i]) ? 1 : 0) != 0, (Object)"varname must not be empty");
            this.varTypes.put(varnames[i], vartypes[i]);
        }
    }

    public WhereHelper build() {
        return new WhereHelper(this);
    }

    private static String validOrderBy(String input) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)(input = Strings.nullToEmpty((String)input).trim())) && Pattern.compile("((^|,)\\s*('\\w+'|\\w+)(?: +(ASC|DESC))?)*", 2).matcher(input).matches() ? 1 : 0) != 0, (String)"INVALID ORDER BY COLUMN %s", (Object)input);
        return input;
    }

    private static String validLogicOperator(String input) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)(input = Strings.nullToEmpty((String)input).trim())) && Pattern.compile("AND|OR", 2).matcher(input).matches() ? 1 : 0) != 0, (String)" INVALID logic operator [%s],'AND' or 'OR' required", (Object)input);
        return input;
    }

    private static String loadTemplate(String tmpl) {
        URL url = (URL)Preconditions.checkNotNull((Object)WhereHelper.class.getResource(tmpl), (String)"not found template %s", (Object)tmpl);
        try {
            return Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static ImmutableMap<String, String> loadAllTemplates() {
        return Maps.toMap((Iterable)Sets.newHashSet((Object[])new String[]{TMPL_EXP, TMPL_EQUAL, TMPL_EQUAL_IF, TMPL_IF_ELSE, TMPL_GROUP_BY, TMPL_ORDER_BY, TMPL_LIMIT, TMPL_BEFORE_COND, TMPL_AFTER_COND}), (Function)new Function<String, String>(){

            public String apply(String input) {
                return BeanShellWhereBuilder.loadTemplate("bsh_" + input);
            }
        });
    }

    static /* synthetic */ ImmutableMap access$000() {
        return BeanShellWhereBuilder.loadAllTemplates();
    }

    private static class Tmpls {
        private static final ImmutableMap<String, String> tmpls = BeanShellWhereBuilder.access$000();

        private Tmpls() {
        }
    }
}

