package gu.sql2java.pagehelper.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.ElementType;

/**
 * sql2java 分页查询启动注解
 * @author guyadong
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD,ElementType.TYPE})
@Documented
public @interface Sql2javaEnablePage {
	/** 为{@code true}启用分页查询 */
	boolean value() default true;
	/** HTTP请求中定义pageNum(页码参数,1-based)的属性名 */
	String pageNumKey() default "pageNum";
	/** HTTP请求中定义pageSize(每页数量)的属性名 */
	String pageSizeKey() default "pageSize";
	/** HTTP请求中定义count(是否进行count查询,默认true)的属性名 */
	String countKey() default "count";
	/** HTTP请求中定义count查询的字段名的属性名 */
	String countColumnKey() default "countColumn";
}
