package gu.sql2java.wherehelper;

import static gu.sql2java.wherehelper.CompareOp.*;
/**
 * 范围边界类型定义<br>
 * <ul>
 * <li>CLOSE 范围包含边界值本身</li>
 * <li>OPEN 范围不包含边界值本身</li>
 * </ul>
 * @author guyadong
 * @since 3.25.0
 */
public enum RangeType {
  /**
   * 左侧范围(较小值)不包含左侧值，右侧范围(较大值)包含右侧值，
   */
  OPENCLOSE (GT,LE),
  /**
   * 左侧范围(较小值)不包含左侧值，右侧范围(较大值)包不含右侧值，
   */
  OPENOPEN (GT,LT),
  /**
   * 左侧范围(较小值)包含左侧值，右侧范围(较大值)不包含右侧值，
   */
  CLOSEOPEN(GE,LT),
	/**
	 * 左侧范围(较小值)包含左侧值，右侧范围(较大值)包含右侧值，
	 */
	CLOSECLOSE(GE,LE);
	/**
	 * 左侧范围(较小值)的比较运算符
	 */
	public final CompareOp lower;
	/**
	 * 右侧范围(较大值)的比较运算符
	 */
	public final CompareOp upper;
	private RangeType(CompareOp lower,CompareOp upper) {
		this.lower = lower;
		this.upper = upper;
	}
}

