package gu.sql2java.wherehelper.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import gu.sql2java.wherehelper.BitAggFun;

import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;

/**
 * 整数字段比特位测试表达式
 * @author guyadong
 * @since 3.27.0
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD,ElementType.TYPE})
@Documented
@Repeatable(BitTests.class)
public @interface BitTest{
	/**
	 * 等价比较的字段名
	 */
	String value() default "";
	/**
	 * 为{@code true} 不检查字段参数是否为{@code null}或空
	 */
	boolean notCheckEmpty() default false;
	/**
	 * 为{@code true}执行OR运算，即位运算不为0即为{@code true},否则要求位运算等于MASK
	 */
	boolean bitOr() default false;
	/**
	 * 为{@code true}输出等价或为NULL表达式，例如 (left=value OR left IS NULL)
	 */
	boolean orNull() default false;
	/**
     * 等价比较表达式的左侧字段名，为空则默认为{@link #value()}
     */
    String left() default "";
    /**
     * 聚合函数
     */
    @SuppressWarnings("rawtypes")
	Class<? extends BitAggFun> aggFun() default BitAggFun.class;
}
