package gu.sql2java.wherehelper.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import gu.sql2java.wherehelper.CompareOp;
import gu.sql2java.wherehelper.VarTestType;

import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;

/**
 * WhereHelper 条件等价表达式注解
 * @author guyadong
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD,ElementType.TYPE})
@Documented
@Repeatable(EqualIfs.class)
public @interface EqualIf{
	/**
	 * 条件测试表达式,为true时创建表达式
	 */
	String test() default "";
	/**
	 * 要求为null的变量名列表,['var1','var2'],等价于'null==${var1} && null==${var2}',为空则默认为'true'
	 * @since 3.25.0
	 */
	String[] testNullVars() default{};
	/**
	 * 要求不为null的变量名列表,['var1','var2'],等价于'null!=${var1} && null!=${var2}',为空则默认为'true'
	 * @since 3.25.0
	 */
	String[] testNonullVars() default{};
	/**
	 * 要求为{@code null}或空的变量名列表,['var1','var2'],等价于'isEmpty(${var1}) && isEmpty(${var2})',为空则默认为'true'
	 * @since 3.25.0
	 */
	String[] testEmptyVars() default{};
	/**
	 * 要求不为{@code null}或空的变量名列表,['var1','var2'],等价于'!isEmpty(${var1}) && !isEmpty(${var2})',为空则默认为'true'
	 * @since 3.25.0
	 */
	String[] testNoEmptyVars() default{};
	/**
	 * 要求为{@code true}的变量名列表,['var1','var2'],等价于'isTrue(${var1)} && isTrue(${var2})',为空则默认为'true'
	 * @since 3.25.0
	 */
	String[] testTrueVars() default{};
	/**
	 * 要求为{@code false}的变量名列表,['var1','var2'],等价于'isFalse(${var1}) && isFalse(${var2})',为空则默认为'true'
	 * @since 3.25.0
	 */
	String[] testFalseVars() default{};
	/**
	 * 定义基于{@link #testType()}的条件测试表达式变量名
	 * @since 3.25.0
	 */
	String testVar() default "";
	/**
	 * 变量测试类型
	 * @since 3.25.0
	 */
	VarTestType testType() default VarTestType.EQUAL;
	/**
	 * 条件测试算术操作符
	 * @since 3.25.0
	 */
	CompareOp testOp() default CompareOp.EQ ;
	/**
	 * 变量条件测试的目标值 
	 * @since 3.25.0
	 */
	String testValue() default "";
	/**
	 * 为{@code true}生成表达式对{@link #testValue()} 以字符串对头尾增加单引号,
	 * {@link #testRefValue()}为{@code true}时忽略
	 * @since 3.25.0
	 */
	boolean testQuote() default false;
	/**
	 * 为{@code true}生成表达式对{@link #testValue()} 视为变量名
	 * @since 3.25.0
	 */
	boolean testRefValue() default false;
	/**
	 * 等价比较的字段名
	 */
	String field() default "";
	/**
	 * 为{@code true} 不检查字段参数是否为{@code null}或空
	 * @since 3.25.0
	 */
	boolean notCheckEmpty() default false;
	/**
	 * 为{@code true}执行不等价比较
	 */
	boolean not() default false;
	/**
     * 等价比较表达式的左侧字段名，为空则默认为{@link #field()}
     * @since 3.17.5
     */
    String left() default "";
}
