package gu.sql2java.wherehelper.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.ElementType;

/**
 * WhereHelper GROUP BY 表达式注解
 * @author guyadong
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD,ElementType.TYPE})
@Documented
public @interface GroupBy {
	/**
	 * GROUP BY 字段列表
	 */
	String[] value() default {};

	/**
	 * GROUP BY 字段变量名
	 */
	String groupByVarname() default "group_by_column";
}
