package gu.sql2java.wherehelper.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import gu.sql2java.wherehelper.CompareOp;
import gu.sql2java.wherehelper.LikeOp;
import gu.sql2java.wherehelper.VarTestType;

import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;

/**
 * WhereHelper 模糊匹配表达式注解
 * @author guyadong
 * @since 3.25.0
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD,ElementType.TYPE})
@Documented
@Repeatable(Likes.class)
public @interface Like{
	/**
	 * test表达式执行为true时生成的LIKE表达式
	 */
	String test() default "true";
	/**
	 * 要求为null的变量名列表,['var1','var2'],等价于'null==${var1} && null==${var2}',为空则默认为'true'
	 */
	String[] testNullVars() default{};
	/**
	 * 要求不为null的变量名列表,['var1','var2'],等价于'null!=${var1} && null!=${var2}',为空则默认为'true'
	 */
	String[] testNonullVars() default{};
	/**
	 * 要求为{@code null}或空的变量名列表,['var1','var2'],等价于'isEmpty(${var1}) && isEmpty(${var2})',为空则默认为'true'
	 */
	String[] testEmptyVars() default{};
	/**
	 * 要求不为{@code null}或空的变量名列表,['var1','var2'],等价于!'isEmpty(${var1}) && !isEmpty(${var2})',为空则默认为'true'
	 */
	String[] testNoEmptyVars() default{};
	/**
	 * 要求为{@code true}的变量名列表,['var1','var2'],等价于'isTrue(${var1)} && isTrue(${var2})',为空则默认为'true'
	 */
	String[] testTrueVars() default{};
	/**
	 * 要求为{@code false}的变量名列表,['var1','var2'],等价于'isFalse(${var1}) && isFalse(${var2})',为空则默认为'true'
	 */
	String[] testFalseVars() default{};
	/**
	 * 定义基于{@link #testType()}的条件测试表达式变量名
	 */
	String testVar() default "";
	/**
	 * 变量测试类型
	 */
	VarTestType testType() default VarTestType.EQUAL;
	/**
	 * 条件测试操作符
	 */
	CompareOp testOp() default CompareOp.EQ ;
	/**
	 * 变量条件测试的目标值 
	 */
	String testValue() default "";
	/**
	 * 为{@code true}生成表达式对{@link #testValue()} 以字符串对头尾增加单引号,
	 * {@link #testRefValue()}为{@code true}时忽略
	 */
	boolean testQuote() default false;
	/**
	 * 为{@code true}生成表达式对{@link #testValue()} 视为变量名
	 */
	boolean testRefValue() default false;
	/**
	 * 模糊匹配的字段名
	 */
	String value() default "";
	/**
     *  模糊匹配表达式的左侧字段名
     */
    String left() default "";
	/**
	 * 模糊匹配方式<br>
	 */
    LikeOp op() default LikeOp.DEFAULT;
	/**
	 * 为{@code true}生成表达式对{@link #value()} 视为变量名,否则视为常量
	 */
	boolean refValue() default true;
}
