/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.wherehelper;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import gu.sql2java.BaseRow;
import gu.sql2java.SimpleLog;
import gu.sql2java.bean.BeanPropertyUtils;
import gu.sql2java.wherehelper.BitAggFun;
import gu.sql2java.wherehelper.CompareOp;
import gu.sql2java.wherehelper.LikeOp;
import gu.sql2java.wherehelper.RangeType;
import gu.sql2java.wherehelper.VarTestType;
import gu.sql2java.wherehelper.WhereHelper;
import gu.sql2java.wherehelper.WhereHelperException;
import gu.sql2java.wherehelper.annotations.BitTest;
import gu.sql2java.wherehelper.annotations.Compare;
import gu.sql2java.wherehelper.annotations.EnableWhereHelper;
import gu.sql2java.wherehelper.annotations.Equal;
import gu.sql2java.wherehelper.annotations.EqualIf;
import gu.sql2java.wherehelper.annotations.Expression;
import gu.sql2java.wherehelper.annotations.GroupBy;
import gu.sql2java.wherehelper.annotations.IfElse;
import gu.sql2java.wherehelper.annotations.Like;
import gu.sql2java.wherehelper.annotations.OrderBy;
import gu.sql2java.wherehelper.annotations.Range;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BeanShellWhereBuilder {
    private static final String TMPL_EQUAL = "equal.tmpl";
    private static final String TMPL_BIT_TEST = "bit_test.tmpl";
    private static final String TMPL_EQUAL_IF = "equal_if.tmpl";
    private static final String TMPL_IF_ELSE = "if_else.tmpl";
    private static final String TMPL_LIKE = "like.tmpl";
    private static final String TMPL_COMPARE = "compare.tmpl";
    private static final String TMPL_GROUP_BY = "group_by.tmpl";
    private static final String TMPL_ORDER_BY = "order_by.tmpl";
    private static final String TMPL_EXP = "exp.tmpl";
    private static final String TMPL_LIMIT = "limit.tmpl";
    private static final String TMPL_BEFORE_COND = "before_cond.tmpl";
    private static final String TMPL_AFTER_COND = "after_cond.tmpl";
    public static final String NOT_EQUAL = "$<NOT_EQUAL>";
    public static final String OR_NULL = "$<OR_NULL>";
    public static final String BIT_OR = "$<BIT_OR>";
    public static final String IGNORE_EMPTY = "$<IGNORE_EMPTY>";
    private static final String AND_OR = "$<AND_OR>";
    private static final String TEST = "$<TEST>";
    private static final String AGG_FUN = "$<AGG_FUN>";
    private static final String DEFAULT_ORDER_BY_VAR = "order_by_column";
    private static final String DEFAULT_GROUP_BY_VAR = "group_by_column";
    public static final String KEYWORD_COND_COUNT = "cond_count";
    public static final String KEYWORD_WHERE_BUFFER = "where_buffer";
    public static final String KEYWORD_EXP_BUFFER = "cond_buffer";
    public static final String DT_MYSQL = "MySQL";
    private String selectFrom = "";
    private String andor = "AND";
    private List<String> importLines = Lists.newLinkedList();
    private List<String> conditionCodes = Lists.newLinkedList();
    private List<String> orderByColumns = Lists.newLinkedList();
    private List<String> groupByColumns = Lists.newLinkedList();
    private String sqltype = "MySQL";
    private boolean debuglog = false;
    private boolean pagequery = true;
    private Class<? extends BaseRow> targetClass = BaseRow.class;
    private Set<String> referenceVariables;
    private Map<String, Class<?>> varTypes = Collections.emptyMap();
    private String orderByVarname = "order_by_column";
    private String groupByVarname = "group_by_column";
    static final Function<String, String> FMT_JSON_FIELD_MYSQL = new Function<String, String>(){

        public String apply(String input) {
            input = Strings.nullToEmpty((String)input).trim();
            Matcher matcher = Pattern.compile("(\\w+)->>?(\\$\\.)?(\\w+)|'(\\w+)->>?(\\$\\.)?(\\w+)'").matcher(input);
            StringBuffer buffer = new StringBuffer();
            while (matcher.find()) {
                if (!Strings.isNullOrEmpty((String)matcher.group(1))) {
                    matcher.appendReplacement(buffer, "$1->>'\\$.$3'");
                    continue;
                }
                matcher.appendReplacement(buffer, "$4->>'\\$.$6'");
            }
            matcher.appendTail(buffer);
            return buffer.toString();
        }
    };

    BeanShellWhereBuilder() {
    }

    public boolean debuglog() {
        return this.debuglog;
    }

    public BeanShellWhereBuilder debuglog(boolean debuglog) {
        this.debuglog = debuglog;
        return this;
    }

    public BeanShellWhereBuilder pagequery(boolean pagequery) {
        this.pagequery = pagequery;
        return this;
    }

    public Set<String> getReferenceVariables() {
        return this.referenceVariables;
    }

    public Class<? extends BaseRow> getTargetClass() {
        return this.targetClass;
    }

    public Map<String, Class<?>> getVarTypes() {
        return this.varTypes;
    }

    public String getOrderByVarname() {
        return this.orderByVarname;
    }

    public String getGroupByVarname() {
        return this.groupByVarname;
    }

    public String getOrderByColumns() {
        return Joiner.on((char)',').join(this.orderByColumns);
    }

    public String getGroupByColumns() {
        return Joiner.on((char)',').join(this.groupByColumns);
    }

    public BeanShellWhereBuilder exp(String exp) {
        if (!Strings.isNullOrEmpty((String)(exp = Strings.nullToEmpty((String)exp).trim()))) {
            this.conditionCodes.add(((String)Tmpls.tmpls.get((Object)TMPL_EXP)).replace(AND_OR, this.andor).replace("$<exp>", exp));
        }
        return this;
    }

    public BeanShellWhereBuilder or() {
        this.andor = "OR";
        return this;
    }

    public BeanShellWhereBuilder and() {
        this.andor = "AND";
        return this;
    }

    private BeanShellWhereBuilder equal(String left, String field, boolean not, boolean notCheckEmpty, boolean orNull) {
        if (!Strings.isNullOrEmpty((String)field)) {
            this.conditionCodes.add(((String)Tmpls.tmpls.get((Object)TMPL_EQUAL)).replace(NOT_EQUAL, "" + not).replace(IGNORE_EMPTY, "" + notCheckEmpty).replace(OR_NULL, "" + orNull).replace(AND_OR, this.andor).replace("$<field>", field).replace("$<left>", BeanShellWhereBuilder.column(left, field)));
        }
        return this;
    }

    public BeanShellWhereBuilder equal(String field) {
        return this.equal(null, field, false, true, false);
    }

    public BeanShellWhereBuilder equal(String left, String field) {
        return this.equal(left, field, false, true, false);
    }

    public BeanShellWhereBuilder equalNot(String field) {
        return this.equal(null, field, true, true, false);
    }

    public BeanShellWhereBuilder equalNot(String left, String field) {
        return this.equal(left, field, true, true, false);
    }

    public BeanShellWhereBuilder equalOrNull(String field) {
        return this.equal(null, field, false, false, true);
    }

    public BeanShellWhereBuilder equalOrNull(String left, String field) {
        return this.equal(left, field, false, false, true);
    }

    public BeanShellWhereBuilder equalIfNonEmpty(String field, boolean not) {
        return this.equal(null, field, not, false, false);
    }

    public BeanShellWhereBuilder equalIfNonEmpty(String left, String field, boolean not) {
        return this.equal(left, field, not, false, false);
    }

    public BeanShellWhereBuilder equalIfNonEmpty(String field) {
        return this.equal(null, field, false, false, false);
    }

    public BeanShellWhereBuilder equalIfNonEmpty(String left, String field) {
        return this.equal(left, field, false, false, false);
    }

    public BeanShellWhereBuilder equalIf(String test, String left, String field, boolean not, boolean notCheckEmpty) {
        if (!Strings.isNullOrEmpty((String)test) && !Strings.isNullOrEmpty((String)field)) {
            this.conditionCodes.add(((String)Tmpls.tmpls.get((Object)TMPL_EQUAL_IF)).replace(NOT_EQUAL, "" + not).replace(IGNORE_EMPTY, "" + notCheckEmpty).replace(AND_OR, this.andor).replace(TEST, test).replace("$<field>", field).replace("$<left>", BeanShellWhereBuilder.column(left, field)));
        }
        return this;
    }

    public BeanShellWhereBuilder equalIf(String test, String[] testNullVars, String[] testNonullVars, String[] testEmptyVars, String[] testNoEmptyVars, String[] testTrueVars, String[] testFalseVars, String left, String field, boolean not, boolean notCheckEmpty) {
        return this.equalIf(BeanShellWhereBuilder.buildTestExps(test, testNullVars, testNonullVars, testEmptyVars, testNoEmptyVars, testTrueVars, testFalseVars), left, field, not, notCheckEmpty);
    }

    public BeanShellWhereBuilder equalIf(String test, String field, boolean not, boolean notCheckEmpty) {
        return this.equalIf(test, field, field, not, notCheckEmpty);
    }

    public BeanShellWhereBuilder equalIf(String test, String left, String field, boolean not) {
        return this.equalIf(test, left, field, not, false);
    }

    public BeanShellWhereBuilder equalIf(String test, String field, boolean not) {
        return this.equalIf(test, field, field, not, false);
    }

    public BeanShellWhereBuilder equalIf(String[] testVars, VarTestType testType, String left, String field, boolean not, boolean notCheckEmpty) {
        return this.equalIf(BeanShellWhereBuilder.renderVars(testVars, testType), left, field, not, notCheckEmpty);
    }

    public BeanShellWhereBuilder equalIf(String[] testVars, VarTestType testType, String field, boolean not, boolean notCheckEmpty) {
        return this.equalIf(BeanShellWhereBuilder.renderVars(testVars, testType), null, field, not, notCheckEmpty);
    }

    public BeanShellWhereBuilder equalIf(String testVar, VarTestType testType, CompareOp testOp, Object testValue, boolean testQuote, boolean testRefValue, String left, String field, boolean not, boolean notCheckEmpty) {
        String test = BeanShellWhereBuilder.buildTestVarExp(testVar, testType, testOp, testValue, testQuote, testRefValue, field);
        if (!test.isEmpty()) {
            return this.equalIf(test, left, left, not, notCheckEmpty);
        }
        return this;
    }

    BeanShellWhereBuilder bitTest(String left, String field, boolean bitOr, boolean notCheckEmpty, Class<? extends BitAggFun> aggFun) {
        if (!Strings.isNullOrEmpty((String)field)) {
            this.conditionCodes.add(((String)Tmpls.tmpls.get((Object)TMPL_BIT_TEST)).replace(BIT_OR, "" + bitOr).replace(IGNORE_EMPTY, "" + notCheckEmpty).replace(AND_OR, this.andor).replace(AGG_FUN, null == aggFun || BitAggFun.class.equals(aggFun) ? "null" : aggFun.getName() + ".class").replace("$<field>", field).replace("$<left>", BeanShellWhereBuilder.column(left, field)));
        }
        return this;
    }

    public BeanShellWhereBuilder bitTest(String field) {
        return this.bitTest(null, field, false, false, null);
    }

    public BeanShellWhereBuilder bitTest(String field, Class<? extends BitAggFun> aggFun) {
        return this.bitTest(null, field, false, false, aggFun);
    }

    public BeanShellWhereBuilder bitTest(String left, String field) {
        return this.bitTest(left, field, false, false, null);
    }

    public BeanShellWhereBuilder bitTest(String left, String field, Class<? extends BitAggFun> aggFun) {
        return this.bitTest(left, field, false, false, aggFun);
    }

    public BeanShellWhereBuilder ifelse(String test, String doStatement, String elseStatement) {
        if (!Strings.isNullOrEmpty((String)test) && !Strings.isNullOrEmpty((String)doStatement)) {
            elseStatement = Strings.nullToEmpty((String)elseStatement);
            this.conditionCodes.add(((String)Tmpls.tmpls.get((Object)TMPL_IF_ELSE)).replace(AND_OR, this.andor).replace(TEST, test).replace("$<THEN>", doStatement).replace("$<ELSE>", elseStatement));
        }
        return this;
    }

    public BeanShellWhereBuilder ifelse(String test, String[] testNullVars, String[] testNonullVars, String[] testEmptyVars, String[] testNoEmptyVars, String[] testTrueVars, String[] testFalseVars, String doStatement, String elseStatement) {
        if (BeanPropertyUtils.allEmpty(test, testNullVars, testNonullVars, testEmptyVars, testNoEmptyVars, testTrueVars, testFalseVars)) {
            return this;
        }
        return this.ifelse(BeanShellWhereBuilder.buildTestExps(test, testNullVars, testNonullVars, testEmptyVars, testNoEmptyVars, testTrueVars, testFalseVars), doStatement, elseStatement);
    }

    public BeanShellWhereBuilder ifelse(String[] testVars, VarTestType testType, String doStatement, String elseStatement) {
        return this.ifelse(BeanShellWhereBuilder.renderVars(testVars, VarTestType.checkVarTestType(testType, 1)), doStatement, elseStatement);
    }

    public BeanShellWhereBuilder testVar(String testVar, VarTestType testType, CompareOp testOp, Object testValue, boolean testQuote, boolean testRefValue, String doStatement, String elseStatement) {
        if (!Strings.isNullOrEmpty((String)testVar) && null != testType && !Strings.isNullOrEmpty((String)doStatement)) {
            String test = testType.render(testVar, testOp, testValue, testQuote, testRefValue);
            return this.ifelse(test, doStatement, elseStatement);
        }
        return this;
    }

    public BeanShellWhereBuilder testVar(String testVar, VarTestType testType, CompareOp testOp, Object testValue, boolean testQuote, boolean testRefValue, String doStatement) {
        return this.testVar(testVar, VarTestType.checkVarTestType(testType, 3), testOp, testValue, testQuote, testRefValue, doStatement, null);
    }

    public BeanShellWhereBuilder testVar(String testVar, VarTestType testType, CompareOp testOp, Object testValue, String doStatement) {
        return this.testVar(testVar, VarTestType.checkVarTestType(testType, 3), testOp, testValue, false, false, doStatement, null);
    }

    public BeanShellWhereBuilder testVar(String testVar, VarTestType testType, Object testValue, boolean testQuote, boolean testRefValue, String doStatement) {
        return this.testVar(testVar, VarTestType.checkVarTestType(testType, 2), null, testValue, testQuote, testRefValue, doStatement, null);
    }

    public BeanShellWhereBuilder testVar(String testVar, VarTestType testType, Object testValue, String doStatement) {
        return this.testVar(testVar, VarTestType.checkVarTestType(testType, 2), null, testValue, false, false, doStatement, null);
    }

    public BeanShellWhereBuilder testVar(String testVar, VarTestType testType, String doStatement) {
        return this.testVar(testVar, VarTestType.checkVarTestType(testType, 1), null, null, false, false, doStatement, null);
    }

    public BeanShellWhereBuilder onlyif(String test, String doStatement) {
        return this.ifelse(test, doStatement, null);
    }

    public BeanShellWhereBuilder onlyif(String test, String[] testNullVars, String[] testNonullVars, String[] testEmptyVars, String[] testNoEmptyVars, String[] testTrueVars, String[] testFalseVars, String doStatement) {
        if (BeanPropertyUtils.allEmpty(test, testNullVars, testNonullVars, testEmptyVars, testNoEmptyVars, testTrueVars, testFalseVars)) {
            return this;
        }
        return this.ifelse(BeanShellWhereBuilder.buildTestExps(test, testNullVars, testNonullVars, testEmptyVars, testNoEmptyVars, testTrueVars, testFalseVars), doStatement, null);
    }

    public BeanShellWhereBuilder onlyif(String[] testVars, VarTestType testType, String doStatement) {
        return this.ifelse(BeanShellWhereBuilder.renderVars(testVars, VarTestType.checkVarTestType(testType, 1)), doStatement, null);
    }

    public BeanShellWhereBuilder like(String test, String left, String field, LikeOp likeOp, boolean refValue) {
        if (!Strings.isNullOrEmpty((String)field)) {
            BeanShellWhereBuilder.checkValidLeft(refValue, left);
            this.conditionCodes.add(((String)Tmpls.tmpls.get((Object)TMPL_LIKE)).replace(AND_OR, this.andor).replace("${$<field>}", Strings.isNullOrEmpty((String)left) || refValue ? "${$<field>}" : JSON.toJSONString((Object)field)).replace("$<left>", BeanShellWhereBuilder.column(left, field)).replace("$<field>", field).replace(TEST, Strings.isNullOrEmpty((String)test) ? "true" : test).replace("$<LIKE_OP>", ((LikeOp)((Object)MoreObjects.firstNonNull((Object)((Object)likeOp), (Object)((Object)LikeOp.DEFAULT)))).name()));
        }
        return this;
    }

    public BeanShellWhereBuilder like(String test, String[] testNullVars, String[] testNonullVars, String[] testEmptyVars, String[] testNoEmptyVars, String[] testTrueVars, String[] testFalseVars, String left, String field, LikeOp likeOp, boolean refValue) {
        return this.like(BeanShellWhereBuilder.buildTestExps(test, testNullVars, testNonullVars, testEmptyVars, testNoEmptyVars, testTrueVars, testFalseVars), left, field, likeOp, refValue);
    }

    public BeanShellWhereBuilder like(String left, String field, LikeOp likeOp, boolean refValue) {
        return this.like(null, left, field, likeOp, refValue);
    }

    public BeanShellWhereBuilder like(String left, String field, boolean refValue) {
        return this.like(null, left, field, LikeOp.DEFAULT, refValue);
    }

    public BeanShellWhereBuilder like(String left, String field) {
        return this.like(null, left, field, LikeOp.DEFAULT, true);
    }

    public BeanShellWhereBuilder like(String field) {
        return this.like(null, null, field, LikeOp.DEFAULT, true);
    }

    public BeanShellWhereBuilder likeIf(String test, String left, String field, LikeOp likeOp, boolean refValue) {
        if (!Strings.isNullOrEmpty((String)test)) {
            return this.like(test, left, field, likeOp, refValue);
        }
        return this;
    }

    public BeanShellWhereBuilder likeIf(String test, String left, String field, boolean refValue) {
        return this.likeIf(test, left, field, LikeOp.DEFAULT, refValue);
    }

    public BeanShellWhereBuilder likeIf(String test, String field) {
        return this.likeIf(test, null, field, LikeOp.DEFAULT, true);
    }

    public BeanShellWhereBuilder likeIf(String[] testVars, VarTestType testType, String left, String field, LikeOp likeOp, boolean refValue) {
        return this.likeIf(BeanShellWhereBuilder.renderVars(testVars, testType), left, field, likeOp, refValue);
    }

    public BeanShellWhereBuilder likeIf(String[] testVars, VarTestType testType, String left, String field, LikeOp likeOp) {
        return this.likeIf(BeanShellWhereBuilder.renderVars(testVars, testType), left, field, likeOp, true);
    }

    public BeanShellWhereBuilder likeIf(String[] testVars, VarTestType testType, String field, LikeOp likeOp) {
        return this.likeIf(BeanShellWhereBuilder.renderVars(testVars, testType), null, field, likeOp, true);
    }

    public BeanShellWhereBuilder likeIf(String testVar, VarTestType testType, CompareOp testOp, Object testValue, boolean testQuote, boolean testRefValue, String left, String field, LikeOp likeOp, boolean refValue) {
        String test = BeanShellWhereBuilder.buildTestVarExp(testVar, testType, testOp, testValue, testQuote, testRefValue, field);
        return this.likeIf(test, left, field, likeOp, refValue);
    }

    public BeanShellWhereBuilder compare(String test, String left, String field, CompareOp op, boolean quote, boolean refValue, Boolean checkFieldEmpty) {
        if (!Strings.isNullOrEmpty((String)field) && null != op) {
            BeanShellWhereBuilder.checkValidLeft(refValue, left);
            if (!refValue && !quote && field.replaceAll("\\s*", "").isEmpty()) {
                throw new WhereHelperException("NOT EMPTY string required for field if refValue is false");
            }
            String checkEmpty = refValue ? ((Boolean)MoreObjects.firstNonNull((Object)checkFieldEmpty, (Object)quote) != false ? "!isEmpty(${$<field>})" : "isNonull(${$<field>})") : "true";
            this.conditionCodes.add(((String)Tmpls.tmpls.get((Object)TMPL_COMPARE)).replace(AND_OR, this.andor).replace("$<CHECK_EMPTY>", checkEmpty).replace("${$<field>}", Strings.isNullOrEmpty((String)left) || refValue ? "${$<field>}" : field).replace("$<left>", BeanShellWhereBuilder.column(left, field)).replace("$<field>", field).replace(TEST, Strings.isNullOrEmpty((String)test) ? "true" : test).replace("$<QUOTE>", String.valueOf(quote)).replace("$<COMPARE_OP>", op.op));
        }
        return this;
    }

    public BeanShellWhereBuilder compare(String test, String[] testNullVars, String[] testNonullVars, String[] testEmptyVars, String[] testNoEmptyVars, String[] testTrueVars, String[] testFalseVars, String left, String field, CompareOp compareOp, boolean quote, Boolean checkFieldEmpty) {
        return this.compare(BeanShellWhereBuilder.buildTestExps(test, testNullVars, testNonullVars, testEmptyVars, testNoEmptyVars, testTrueVars, testFalseVars), left, field, compareOp, quote, true, checkFieldEmpty);
    }

    public BeanShellWhereBuilder compare(String left, String field, CompareOp op, boolean quote, boolean refValue) {
        return this.compare(null, left, field, op, quote, refValue, null);
    }

    public BeanShellWhereBuilder compare(String left, String field, CompareOp op, boolean quote) {
        return this.compare(null, left, field, op, quote, true, null);
    }

    public BeanShellWhereBuilder compare(String field, CompareOp op, boolean quote) {
        return this.compare(null, null, field, op, quote, true, null);
    }

    public BeanShellWhereBuilder compareIf(String test, String left, String field, CompareOp op, boolean quote, boolean refValue) {
        if (!Strings.isNullOrEmpty((String)test)) {
            return this.compare(test, left, field, op, quote, refValue, null);
        }
        return this;
    }

    public BeanShellWhereBuilder compareIf(String test, String field, CompareOp op, boolean quote) {
        return this.compareIf(test, null, field, op, quote, true);
    }

    public BeanShellWhereBuilder compareIf(String[] testVars, VarTestType testType, String left, String field, CompareOp op, boolean quote) {
        return this.compareIf(BeanShellWhereBuilder.renderVars(testVars, testType), left, field, op, quote, true);
    }

    public BeanShellWhereBuilder compareIf(String[] testVars, VarTestType testType, String field, CompareOp op, boolean quote) {
        return this.compareIf(BeanShellWhereBuilder.renderVars(testVars, testType), null, field, op, quote, true);
    }

    public BeanShellWhereBuilder compareIf(String testVar, VarTestType testType, CompareOp testOp, Object testValue, boolean testQuote, boolean testRefValue, String left, String field, CompareOp op, boolean quote, boolean refValue) {
        String test = BeanShellWhereBuilder.buildTestVarExp(testVar, testType, testOp, testValue, testQuote, testRefValue, field);
        return this.compareIf(test, left, field, op, quote, refValue);
    }

    public BeanShellWhereBuilder range(String test, String field, String lowerVar, String lowerSuffix, boolean lowerRefValue, String upperVar, String upperSuffix, boolean upperRefValue, RangeType rangeType, boolean quote, Boolean checkFieldEmpty) {
        if (!Strings.isNullOrEmpty((String)field)) {
            rangeType = (RangeType)((Object)MoreObjects.firstNonNull((Object)((Object)rangeType), (Object)((Object)RangeType.CLOSEOPEN)));
            this.compare(test, field, BeanShellWhereBuilder.rangeVar(field, lowerVar, lowerSuffix), rangeType.lower, quote, lowerRefValue, checkFieldEmpty);
            this.compare(test, field, BeanShellWhereBuilder.rangeVar(field, upperVar, upperSuffix), rangeType.upper, quote, upperRefValue, checkFieldEmpty);
        }
        return this;
    }

    public BeanShellWhereBuilder range(String test, String[] testNullVars, String[] testNonullVars, String[] testEmptyVars, String[] testNoEmptyVars, String[] testTrueVars, String[] testFalseVars, String field, String lowerVar, String lowerSuffix, boolean lowerRefValue, String upperVar, String upperSuffix, boolean upperRefValue, RangeType rangeType, boolean quote, Boolean checkFieldEmpty) {
        return this.range(BeanShellWhereBuilder.buildTestExps(test, testNullVars, testNonullVars, testEmptyVars, testNoEmptyVars, testTrueVars, testFalseVars), field, lowerVar, lowerSuffix, lowerRefValue, upperVar, upperSuffix, upperRefValue, rangeType, quote, checkFieldEmpty);
    }

    public BeanShellWhereBuilder range(String field, String lowerVar, String lowerSuffix, boolean lowerRefValue, String upperVar, String upperSuffix, boolean upperRefValue, RangeType rangeType, boolean quote) {
        return this.range(null, field, lowerVar, lowerSuffix, lowerRefValue, upperVar, upperSuffix, upperRefValue, rangeType, quote, null);
    }

    public BeanShellWhereBuilder range(String field, String lowerVar, String upperVar, RangeType rangeType, boolean quote) {
        return this.range(null, field, lowerVar, "_min", true, upperVar, "_max", true, rangeType, quote, null);
    }

    public BeanShellWhereBuilder range(String field, RangeType rangeType, boolean quote) {
        return this.range(null, field, null, "_min", true, null, "_max", true, rangeType, quote, null);
    }

    public BeanShellWhereBuilder range(String field, boolean quote) {
        return this.range(null, field, null, "_min", true, null, "_max", true, RangeType.OPENCLOSE, quote, null);
    }

    public BeanShellWhereBuilder rangeIf(String test, String field, String lowerVar, String lowerSuffix, boolean lowerRefValue, String upperVar, String upperSuffix, boolean upperRefValue, RangeType rangeType, boolean quote) {
        if (!Strings.isNullOrEmpty((String)test)) {
            return this.range(test, field, lowerVar, lowerSuffix, lowerRefValue, upperVar, upperSuffix, upperRefValue, rangeType, quote, null);
        }
        return this;
    }

    public BeanShellWhereBuilder rangeIf(String test, String field, String lowerVar, String upperVar, RangeType rangeType, boolean quote) {
        return this.rangeIf(test, field, lowerVar, "_min", true, upperVar, "_max", true, rangeType, quote);
    }

    public BeanShellWhereBuilder rangeIf(String test, String field, boolean quote) {
        return this.rangeIf(test, field, null, "_min", true, null, "_max", true, RangeType.OPENCLOSE, quote);
    }

    public BeanShellWhereBuilder rangeIf(String[] testVars, VarTestType testType, String field, String lowerVar, String lowerSuffix, boolean lowerRefValue, String upperVar, String upperSuffix, boolean upperRefValue, RangeType rangeType, boolean quote) {
        return this.rangeIf(BeanShellWhereBuilder.renderVars(testVars, testType), field, lowerVar, lowerSuffix, lowerRefValue, upperVar, upperSuffix, upperRefValue, rangeType, quote);
    }

    public BeanShellWhereBuilder rangeIf(String[] testNullVars, VarTestType testType, String field, String lowerVar, String upperVar, RangeType rangeType, boolean quote) {
        return this.range(BeanShellWhereBuilder.renderVars(testNullVars, testType), field, lowerVar, "_min", true, upperVar, "_max", true, rangeType, quote, null);
    }

    public BeanShellWhereBuilder selectFrom(String selectFrom) {
        if (!Strings.isNullOrEmpty((String)selectFrom)) {
            this.selectFrom = selectFrom;
        }
        return this;
    }

    public BeanShellWhereBuilder orderBy(String columnName, boolean desc) {
        if (!Strings.isNullOrEmpty((String)(columnName = Strings.nullToEmpty((String)columnName).trim()))) {
            Preconditions.checkArgument((boolean)columnName.matches("('\\w+'|\\w+)"));
            this.orderByColumns.add(columnName + (desc ? " DESC " : ""));
        }
        return this;
    }

    public BeanShellWhereBuilder orderBy(String columnName) {
        if (!Strings.isNullOrEmpty((String)columnName)) {
            this.orderByColumns.add(BeanShellWhereBuilder.validOrderBy(columnName));
        }
        return this;
    }

    public BeanShellWhereBuilder orderByVar(String varName) {
        if (!Strings.isNullOrEmpty((String)varName)) {
            varName = varName.trim();
            Preconditions.checkArgument((boolean)varName.matches("^[_a-zA-Z]\\w*(\\.\\w+)?$"), (String)"INVALID variable name [%s]", (Object)varName);
            this.orderByVarname = varName;
        }
        return this;
    }

    public BeanShellWhereBuilder groupBy(String ... columnNames) {
        if (null != columnNames) {
            Iterable normalized = Iterables.transform(Arrays.asList(columnNames), BeanShellWhereBuilder.getFormatJsonFieldFunction());
            Iterables.addAll(this.groupByColumns, (Iterable)Iterables.filter((Iterable)normalized, s -> !Strings.isNullOrEmpty((String)s)));
        }
        return this;
    }

    public BeanShellWhereBuilder groupByVar(String varName) {
        if (!Strings.isNullOrEmpty((String)varName)) {
            varName = varName.trim();
            Preconditions.checkArgument((boolean)varName.matches("$[[:alpha:]]\\w?"));
            this.groupByVarname = varName;
        }
        return this;
    }

    public BeanShellWhereBuilder imports(String ... imports) {
        if (null != imports) {
            return this.withImports(Arrays.asList(imports));
        }
        return this;
    }

    public BeanShellWhereBuilder withImports(Iterable<String> imports) {
        if (null != imports) {
            Iterable trans = Iterables.transform(imports, imp -> {
                if (!(imp = Strings.nullToEmpty((String)imp).trim()).isEmpty()) {
                    if (!imp.startsWith("import")) {
                        imp = "import " + imp;
                    }
                    if (!imp.endsWith(";")) {
                        imp = imp + ";";
                    }
                    imp = imp.replace('$', '.');
                }
                return imp;
            });
            Iterables.addAll(this.importLines, (Iterable)trans);
        }
        return this;
    }

    public BeanShellWhereBuilder from(Annotation[] annots) {
        if (null != annots) {
            for (Annotation a : annots) {
                String testexps;
                String testVarExp;
                Annotation eq;
                if (a.annotationType() == EnableWhereHelper.class) {
                    EnableWhereHelper enableWhereHelper = (EnableWhereHelper)a;
                    this.selectFrom = enableWhereHelper.value();
                    this.debuglog = enableWhereHelper.debuglog();
                    this.andor = BeanShellWhereBuilder.validLogicOperator(enableWhereHelper.logicOperator());
                    this.targetClass = enableWhereHelper.targetClass();
                    this.buildVarTypes(enableWhereHelper);
                    continue;
                }
                if (a.annotationType() == Equal.class) {
                    eq = (Equal)a;
                    this.equal(eq.left(), eq.value(), eq.not(), eq.orNull() ? false : eq.notCheckEmpty(), eq.orNull());
                    continue;
                }
                if (a.annotationType() == BitTest.class) {
                    eq = (BitTest)a;
                    this.bitTest(eq.left(), eq.value(), eq.bitOr(), eq.orNull() ? false : eq.notCheckEmpty(), eq.aggFun());
                    continue;
                }
                if (a.annotationType() == EqualIf.class) {
                    eq = (EqualIf)a;
                    testVarExp = BeanShellWhereBuilder.buildTestVarExp(eq.testVar(), eq.testType(), eq.testOp(), eq.testValue(), eq.testQuote(), eq.testRefValue(), eq.field());
                    testexps = BeanShellWhereBuilder.buildTestExps(eq.test(), eq.testNullVars(), eq.testNonullVars(), eq.testEmptyVars(), eq.testNoEmptyVars(), eq.testTrueVars(), eq.testFalseVars());
                    this.equalIf(BeanShellWhereBuilder.reduceExps(testexps, testVarExp), eq.left(), eq.field(), eq.not(), eq.notCheckEmpty());
                    continue;
                }
                if (a.annotationType() == Expression.class) {
                    Expression exp = (Expression)a;
                    this.exp(exp.value());
                    continue;
                }
                if (a.annotationType() == Like.class) {
                    Like like = (Like)a;
                    testVarExp = BeanShellWhereBuilder.buildTestVarExp(like.testVar(), like.testType(), like.testOp(), like.testValue(), like.testQuote(), like.testRefValue(), like.value());
                    testexps = BeanShellWhereBuilder.buildTestExps(like.test(), like.testNullVars(), like.testNonullVars(), like.testEmptyVars(), like.testNoEmptyVars(), like.testTrueVars(), like.testFalseVars());
                    this.like(BeanShellWhereBuilder.reduceExps(testexps, testVarExp), like.left(), like.value(), like.op(), like.refValue());
                    continue;
                }
                if (a.annotationType() == Compare.class) {
                    Compare cmp = (Compare)a;
                    testVarExp = BeanShellWhereBuilder.buildTestVarExp(cmp.testVar(), cmp.testType(), cmp.testOp(), cmp.testValue(), cmp.testQuote(), cmp.testRefValue(), cmp.value());
                    testexps = BeanShellWhereBuilder.buildTestExps(cmp.test(), cmp.testNullVars(), cmp.testNonullVars(), cmp.testEmptyVars(), cmp.testNoEmptyVars(), cmp.testTrueVars(), cmp.testFalseVars());
                    this.compare(BeanShellWhereBuilder.reduceExps(testexps, testVarExp), cmp.left(), cmp.value(), cmp.op(), cmp.quote(), cmp.refValue(), cmp.checkFieldEmpty().length == 0 ? cmp.quote() : cmp.checkFieldEmpty()[0]);
                    continue;
                }
                if (a.annotationType() == Range.class) {
                    Range range = (Range)a;
                    testVarExp = BeanShellWhereBuilder.buildTestVarExp(range.testVar(), range.testType(), range.testOp(), range.testValue(), range.quote(), range.testRefValue(), range.testVar());
                    testexps = BeanShellWhereBuilder.buildTestExps(range.test(), range.testNullVars(), range.testNonullVars(), range.testEmptyVars(), range.testNoEmptyVars(), range.testTrueVars(), range.testFalseVars());
                    this.range(BeanShellWhereBuilder.reduceExps(testexps, testVarExp), range.field(), range.lowerVar(), range.lowerSuffix(), range.lowerRefValue(), range.upperVar(), range.upperSuffix(), range.upperRefValue(), range.rangeType(), range.quote(), range.checkFieldEmpty().length == 0 ? range.quote() : range.checkFieldEmpty()[0]);
                    continue;
                }
                if (a.annotationType() == IfElse.class) {
                    IfElse ifelse = (IfElse)a;
                    testVarExp = BeanShellWhereBuilder.buildTestVarExp(ifelse.testVar(), ifelse.testType(), ifelse.testOp(), ifelse.testValue(), ifelse.testQuote(), ifelse.testRefValue(), ifelse.testVar());
                    testexps = BeanShellWhereBuilder.buildTestExps(ifelse.test(), ifelse.testNullVars(), ifelse.testNonullVars(), ifelse.testEmptyVars(), ifelse.testNoEmptyVars(), ifelse.testTrueVars(), ifelse.testFalseVars());
                    this.ifelse(BeanShellWhereBuilder.reduceExps(testexps, testVarExp), ifelse.doStatement(), ifelse.elseStatement());
                    continue;
                }
                if (a.annotationType() == OrderBy.class) {
                    String[] orderBys;
                    OrderBy orderBy = (OrderBy)a;
                    for (String o : orderBys = orderBy.value()) {
                        this.orderBy(o);
                    }
                    this.orderByVar(orderBy.orderByVarname());
                    continue;
                }
                if (a.annotationType() == GroupBy.class) {
                    this.groupBy(((GroupBy)a).value());
                    continue;
                }
                try {
                    Method method = a.annotationType().getMethod("value", new Class[0]);
                    Class<?> returnType = method.getReturnType();
                    if (!returnType.isArray() || !Annotation.class.isAssignableFrom(returnType.getComponentType())) continue;
                    this.from((Annotation[])method.invoke((Object)a, new Object[0]));
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
        }
        return this;
    }

    String buildScript() {
        this.conditionCodes.add(((String)Tmpls.tmpls.get((Object)TMPL_GROUP_BY)).replace("${group_by_column}", "${" + this.groupByVarname + "}"));
        this.conditionCodes.add(((String)Tmpls.tmpls.get((Object)TMPL_ORDER_BY)).replace("${order_by_column}", "${" + this.orderByVarname + "}"));
        if (this.pagequery && DT_MYSQL.equals(this.sqltype)) {
            this.conditionCodes.add((String)Tmpls.tmpls.get((Object)TMPL_LIMIT));
        }
        StringBuffer buffer = new StringBuffer();
        if (!this.importLines.isEmpty()) {
            buffer.append(Joiner.on((String)"\n").join(this.importLines));
        }
        if (!this.selectFrom.isEmpty()) {
            buffer.append(String.format("where_buffer.append(\"%s \");\n", this.selectFrom));
        }
        String script = buffer.append((String)Tmpls.tmpls.get((Object)TMPL_BEFORE_COND)).append(this.extractReferenceVariables(Joiner.on((String)"\n").join(this.conditionCodes))).append((String)Tmpls.tmpls.get((Object)TMPL_AFTER_COND)).toString();
        SimpleLog.log((boolean)this.debuglog, (String)("\n" + BeanShellWhereBuilder.renderLine(script)), (Object[])new Object[0]);
        SimpleLog.log((boolean)this.debuglog, (String)"referenceVariables: {}", (Object[])new Object[]{Iterables.toString(this.referenceVariables)});
        return script;
    }

    private String extractReferenceVariables(String input) {
        this.referenceVariables = Sets.newHashSet();
        if (!Strings.isNullOrEmpty((String)input)) {
            Pattern pattern = Pattern.compile("\\$\\{(\\w+)\\}");
            Matcher matcher = pattern.matcher(input);
            while (matcher.find()) {
                this.referenceVariables.add(matcher.group(1));
            }
            return this.replaceVar(input);
        }
        return input;
    }

    private String replaceVar(String input) {
        Pattern p = Pattern.compile("(?<!\\\\)\".*?(?<!\\\\)\"");
        Matcher m = p.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String str = m.group(0).replaceAll("\\$\\{(\\w+)\\}", "\"+$1+\"");
            m.appendReplacement(sb, Matcher.quoteReplacement(str));
        }
        m.appendTail(sb);
        return sb.toString().replaceAll("\\$\\{(\\w+)\\}", "$1");
    }

    private void buildVarTypes(EnableWhereHelper annot) {
        Class<?>[] vartypes;
        String[] varnames = annot.varTypeKeys();
        Preconditions.checkArgument((varnames.length == (vartypes = annot.varTypeValues()).length ? 1 : 0) != 0, (Object)"INVALID variable type defined by EnableWhereHelper,array length of varTypeKeys must equal with varTypeValues");
        this.varTypes = Maps.newHashMap();
        for (int i = 0; i < varnames.length; ++i) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)varnames[i]) ? 1 : 0) != 0, (Object)"varname must not be empty");
            this.varTypes.put(varnames[i], vartypes[i]);
        }
    }

    public WhereHelper build() {
        return new WhereHelper(this);
    }

    private static String buildTestVarExp(String testVar, VarTestType testType, CompareOp testOp, Object testValue, boolean testQuote, boolean testRefValue, String field) {
        if (!Strings.isNullOrEmpty((String)field) && null != testType) {
            if (testType.opcount > 1 && BeanPropertyUtils.isEmpty(testValue)) {
                return "";
            }
            if (testType.opcount > 2 && null == testOp) {
                return "";
            }
            if (Strings.isNullOrEmpty((String)testVar)) {
                testVar = field;
            }
            return testType.render(testVar, testOp, testValue, testQuote, testRefValue);
        }
        return "";
    }

    static String renderLine(String input) {
        if (!Strings.isNullOrEmpty((String)input)) {
            Pattern p1 = Pattern.compile("^(.*)", 8);
            Matcher m1 = p1.matcher(input);
            StringBuffer sb = new StringBuffer();
            int line = 0;
            while (m1.find()) {
                m1.appendReplacement(sb, String.format("%03d:$1", ++line));
            }
            m1.appendTail(sb);
            return sb.toString();
        }
        return input;
    }

    private static String rangeVar(String field, String var, String suffix) {
        if (!BeanPropertyUtils.isEmpty(var)) {
            return var;
        }
        if (!Strings.isNullOrEmpty((String)suffix) && !Strings.isNullOrEmpty((String)field)) {
            return field + suffix;
        }
        return null;
    }

    private static String renderVars(String[] testVars, VarTestType testType) {
        String truestr = String.valueOf(true);
        if (!BeanPropertyUtils.isEmpty(testVars) && null != testType) {
            String rx;
            String defOp = " && ";
            String first = ((String)MoreObjects.firstNonNull((Object)testVars[0], (Object)defOp)).trim();
            String combinOp = first.matches(rx = "^(&&|\\|\\|)$") ? " " + first + " " : defOp;
            return Arrays.asList(testVars).stream().filter(s -> !Strings.isNullOrEmpty((String)s) && !s.trim().matches(rx)).map(testType::render).reduce((l, r) -> l + combinOp + r).orElse(truestr);
        }
        return truestr;
    }

    static String buildTestExps(String test, String[] testNullVars, String[] testNonullVars, String[] testEmptyVars, String[] testNoEmptyVars, String[] testTrueVars, String[] testFalseVars) {
        String truestr = String.valueOf(true);
        String nullexp = BeanShellWhereBuilder.renderVars(testNullVars, VarTestType.NULL);
        String nonullexp = BeanShellWhereBuilder.renderVars(testNonullVars, VarTestType.NONULL);
        String emptyexp = BeanShellWhereBuilder.renderVars(testEmptyVars, VarTestType.EMPTY);
        String noemptyexp = BeanShellWhereBuilder.renderVars(testNoEmptyVars, VarTestType.NOEMPTY);
        String trueexp = BeanShellWhereBuilder.renderVars(testTrueVars, VarTestType.TRUE);
        String falseexp = BeanShellWhereBuilder.renderVars(testFalseVars, VarTestType.FALSE);
        return Arrays.asList(Strings.isNullOrEmpty((String)test) ? truestr : test, nullexp, nonullexp, emptyexp, noemptyexp, trueexp, falseexp).stream().filter(s -> !truestr.equals(s)).reduce((l, r) -> "(" + l + ") && (" + r + ")").orElse(truestr);
    }

    private static String reduceExps(String ... exps) {
        return BeanPropertyUtils.isEmpty(exps) ? "" : Arrays.asList(exps).stream().filter(s -> !Strings.isNullOrEmpty((String)s)).reduce((l, r) -> "(" + l + ") && (" + r + ")").orElse("");
    }

    private static String column(String left, String field) {
        String _left = left;
        if (Strings.isNullOrEmpty((String)_left)) {
            _left = field;
        } else if (_left.endsWith(".")) {
            _left = _left + field;
        } else {
            if (_left.matches(".+->>?$")) {
                _left = _left + field;
            }
            _left = (String)BeanShellWhereBuilder.getFormatJsonFieldFunction().apply((Object)_left);
        }
        return _left;
    }

    private static String checkValidLeft(boolean refValue, String left) {
        if (!refValue && (Strings.isNullOrEmpty((String)left) || left.endsWith("."))) {
            throw new WhereHelperException("INVALID left: " + String.valueOf(left) + " ,not null,not empty,not end with . required");
        }
        return left;
    }

    static Function<String, String> getFormatJsonFieldFunction() {
        return FMT_JSON_FIELD_MYSQL;
    }

    private static String validOrderBy(String input) {
        input = (String)BeanShellWhereBuilder.getFormatJsonFieldFunction().apply((Object)input);
        Matcher matcher = Pattern.compile("((^|,)\\s*(\\w+\\.)?\\w+(->>?'(\\$\\.)?\\w+')?(?: +(ASC|DESC))?)*", 2).matcher(input);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)input) && matcher.matches() ? 1 : 0) != 0, (String)"INVALID ORDER BY COLUMN %s", (Object)input);
        return input;
    }

    private static String validLogicOperator(String input) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)(input = Strings.nullToEmpty((String)input).trim())) && Pattern.compile("AND|OR", 2).matcher(input).matches() ? 1 : 0) != 0, (String)" INVALID logic operator [%s],'AND' or 'OR' required", (Object)input);
        return input;
    }

    private static String loadTemplate(String tmpl) {
        URL url = (URL)Preconditions.checkNotNull((Object)WhereHelper.class.getResource(tmpl), (String)"not found template %s", (Object)tmpl);
        try {
            return Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static ImmutableMap<String, String> loadAllTemplates() {
        return Maps.toMap((Iterable)Sets.newHashSet((Object[])new String[]{TMPL_EXP, TMPL_EQUAL, TMPL_BIT_TEST, TMPL_EQUAL_IF, TMPL_IF_ELSE, TMPL_LIKE, TMPL_COMPARE, TMPL_GROUP_BY, TMPL_ORDER_BY, TMPL_LIMIT, TMPL_BEFORE_COND, TMPL_AFTER_COND}), (Function)new Function<String, String>(){

            public String apply(String input) {
                return BeanShellWhereBuilder.loadTemplate("bsh_" + input);
            }
        });
    }

    static /* synthetic */ ImmutableMap access$000() {
        return BeanShellWhereBuilder.loadAllTemplates();
    }

    private static class Tmpls {
        private static final ImmutableMap<String, String> tmpls = BeanShellWhereBuilder.access$000();

        private Tmpls() {
        }
    }
}

