/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.wherehelper;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import gu.sql2java.SimpleLog;
import gu.sql2java.wherehelper.CompareOp;
import gu.sql2java.wherehelper.WhereHelperException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public enum VarTestType {
    NULL("isNull(${var})"),
    NONULL("isNonull(${var})"),
    EMPTY("isEmpty(${var})"),
    NOEMPTY("!isEmpty(${var})"),
    TRUE("isTrue(${var})"),
    FALSE("isFalse(${var})"),
    EQUALORIN("isNonull(${var}) && eqin(${var},${value})"),
    NOEQUALORIN("isNonull(${var}) && !eqin(${var},${value})"),
    EQUAL("isNonull(${var}) && eq(${var},${value})"),
    NOEQUAL("isNonull(${var}) && !${var}.equals(${value})"),
    COMPARE("isNonull(${var}) && (${var})${op}(${value})");

    public final String tmpl;
    public final int opcount;

    private VarTestType(String tmpl) {
        this.tmpl = tmpl;
        Matcher matcher = Pattern.compile("\\$\\{(\\w+)\\}").matcher(tmpl);
        HashSet ops = Sets.newHashSet();
        while (matcher.find()) {
            ops.add(matcher.group(1));
        }
        this.opcount = ops.size();
    }

    public String render(String var) {
        VarTestType.checkVarTestType(this, 1);
        return this.tmpl.replace("var", String.valueOf(var));
    }

    public String render(String var, CompareOp op, Object value, boolean quote, boolean refValue) {
        if (this.opcount == 3 && null == op) {
            throw new WhereHelperException("op is null");
        }
        if (refValue && (!(value instanceof String) || ((String)value).isEmpty())) {
            throw new WhereHelperException("no empty string required for value if refValue is true");
        }
        if (COMPARE.equals((Object)this)) {
            switch (op) {
                case EQ: {
                    return EQUAL.render(var, op, value, quote, refValue);
                }
                case NE: {
                    return NOEQUAL.render(var, op, value, quote, refValue);
                }
            }
        }
        String vs = String.valueOf(value);
        if (!refValue && quote) {
            vs = JSON.toJSONString((Object)vs);
        }
        String exp = this.tmpl.replace("var", String.valueOf(var)).replace(refValue ? "value" : "${value}", vs);
        if (null != op) {
            exp = exp.replace("${op}", op.jop);
        }
        return exp;
    }

    static VarTestType checkVarTestType(VarTestType testType, int opcount) {
        if (null == testType || testType.opcount != opcount) {
            throw new WhereHelperException(SimpleLog.logString((String)"INVALID VarTestType {},opcount {} required,such as:{}", (Object[])new Object[]{String.valueOf((Object)testType), opcount, Joiner.on((char)',').join(VarTestType.values(opcount))}));
        }
        return testType;
    }

    static List<VarTestType> values(int opcount) {
        return Arrays.asList(VarTestType.values()).stream().filter(v -> v.opcount == 1).collect(Collectors.toList());
    }
}

