/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.wherehelper;

import bsh.EvalError;
import bsh.Interpreter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import gu.sql2java.BaseRow;
import gu.sql2java.RowMetaData;
import gu.sql2java.SimpleLog;
import gu.sql2java.bean.BeanPropertyUtils;
import gu.sql2java.utils.BaseTypeTransformer;
import gu.sql2java.utils.DateSupport;
import gu.sql2java.wherehelper.BeanShellWhereBuilder;
import gu.sql2java.wherehelper.WhereHelpers;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;

public class WhereHelper {
    public static final String VAR_ORDER_BY_COLUMN = "order_by_column";
    public static final String VAR_GROUP_BY_COLUMN = "group_by_column";
    public static final String VAR_LIMIT_ROW_COUNT = "limit_row_count";
    public static final String VAR_LIMIT_OFFSET = "limit_offset";
    private static final String KEYWORD_BSH = "bsh";
    private static final Set<String> KEYWORDS = ImmutableSet.builder().add((Object)"bsh").add((Object)"cond_count").add((Object)"where_buffer").add((Object)"cond_buffer").build();
    private static final HashSet<String> BUILTIN_VARS = Sets.newHashSet((Object[])new String[]{"limit_row_count", "limit_offset"});
    private Interpreter interpreter = new Interpreter();
    private String timeFormatter = DateSupport.TIMESTAMP_FORMATTER_STR;
    PropertyUtilsBean propertyUtils = BeanUtilsBean.getInstance().getPropertyUtils();
    private final String bshScript;
    private boolean debuglog = false;
    private Set<String> referenceVariables = Collections.emptySet();
    private Class<? extends BaseRow> targetClass = BaseRow.class;
    private Map<String, Class<?>> varTypes = Collections.emptyMap();
    private String defaultOrderByColumns;
    private String defaultGroupByColumns;
    private String orderByVar;
    private String groupByVar;
    private final LoadingCache<Class, Function> AGG_FUN_CACHE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Class, Function>(){

        public Function load(Class key) throws Exception {
            return (Function)key.newInstance();
        }
    });

    public WhereHelper(String bshScript) {
        this.bshScript = (String)Preconditions.checkNotNull((Object)bshScript, (Object)"bshScript is null");
        this.interpreter.getNameSpace().importObject((Object)this);
    }

    WhereHelper(BeanShellWhereBuilder builder) {
        this(((BeanShellWhereBuilder)Preconditions.checkNotNull((Object)builder, (Object)"bshScript is null")).buildScript());
        this.referenceVariables = builder.getReferenceVariables();
        this.targetClass = builder.getTargetClass();
        this.varTypes = builder.getVarTypes();
        this.debuglog = builder.debuglog();
        this.defaultOrderByColumns = builder.getOrderByColumns();
        this.defaultGroupByColumns = builder.getGroupByColumns();
        this.orderByVar = builder.getOrderByVarname();
        this.groupByVar = builder.getGroupByVarname();
    }

    public WhereHelper timeFormatter(String timeFormatter) {
        if (!Strings.isNullOrEmpty((String)timeFormatter)) {
            this.timeFormatter = timeFormatter;
        }
        return this;
    }

    public WhereHelper defineVariable(String varname, Object value) {
        return this.defineVariable(varname, value, null);
    }

    public WhereHelper defineVariable(String varname, Object value, Class<?> expectType) {
        if (!Strings.isNullOrEmpty((String)varname)) {
            try {
                value = WhereHelper.guess(value, expectType);
                this.interpreter.set(varname, WhereHelper.escape(value));
                SimpleLog.log((boolean)this.debuglog, (String)"{} = {}", (Object[])new Object[]{varname, value});
            }
            catch (EvalError e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public WhereHelper with(Object params) {
        this.initVars(Preconditions.checkNotNull((Object)params, (Object)"params is null"));
        return this;
    }

    public WhereHelper with(Function<String, String> valueSupplier) {
        if (null != valueSupplier) {
            this.referenceVariables.forEach(varname -> {
                String v = (String)valueSupplier.apply(varname);
                if (null == v) {
                    if (WhereHelpers.isCamelcase(varname)) {
                        v = (String)valueSupplier.apply((Object)WhereHelpers.toSnakecase(varname));
                    } else if (WhereHelpers.isSnakelcase(varname)) {
                        v = (String)valueSupplier.apply((Object)WhereHelpers.toCamelcase(varname));
                    }
                }
                if (null == v) {
                    this.defineVariable((String)varname, v);
                } else {
                    Class<?> varType = this.variableTypeOf((String)varname);
                    if (null == varType) {
                        this.defineVariable((String)varname, v);
                    } else if (String.class == varType) {
                        this.defineVariable((String)varname, v);
                    } else {
                        this.defineVariable((String)varname, JSON.parseObject((String)v, varType, (ParserConfig)ParserConfig.global, null, (int)0, (Feature[])new Feature[0]));
                    }
                }
            });
        }
        return this;
    }

    public String where() {
        try {
            this.beforeWhere();
            StringBuffer buffer = new StringBuffer();
            this.interpreter.set("where_buffer", (Object)buffer);
            this.interpreter.eval(this.bshScript);
            this.unsetVars();
            String where = buffer.toString();
            SimpleLog.log((boolean)this.debuglog, (String)"{}", (Object[])new Object[]{where});
            return where;
        }
        catch (EvalError e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isEmpty(Object value) {
        return BeanPropertyUtils.isEmpty(value);
    }

    public boolean isTrue(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return 0 != ((Number)value).intValue();
        }
        return null != value && value.toString().toLowerCase().matches("true|on|1|y(es)?");
    }

    public boolean isFalse(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if (value instanceof Number) {
            return 0 == ((Number)value).intValue();
        }
        return null != value && value.toString().toLowerCase().matches("false|off|0|no?");
    }

    public boolean isNull(Object value) {
        return null == value;
    }

    public boolean isNonull(Object value) {
        return null != value;
    }

    public String op(String field, boolean not) {
        return this.op(field, field, not, false);
    }

    public String op(String left, String field, boolean not, boolean orNull) {
        if (!Strings.isNullOrEmpty((String)left) && !Strings.isNullOrEmpty((String)field)) {
            try {
                Object value = this.interpreter.get(field);
                String exp = left + " " + this.asCond(value, not);
                if (orNull && null != value) {
                    exp = String.format("(%s OR %s IS NULL)", exp, left);
                }
                return exp;
            }
            catch (EvalError e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String op(String field) {
        return this.op(field, false);
    }

    public String bitAgg(String field, Class clazz) {
        if (!Strings.isNullOrEmpty((String)field)) {
            try {
                Long num;
                Object value = this.interpreter.get(field);
                if (null != clazz) {
                    try {
                        return String.valueOf(((Function)this.AGG_FUN_CACHE.getUnchecked((Object)clazz)).apply(value));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (null != (num = BaseTypeTransformer.asUnsignedLong((Object)value))) {
                    value = num;
                }
                return String.valueOf(value);
            }
            catch (EvalError e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean eqin(Object left, Object right) {
        block6: {
            AtomicReference pattern;
            Date _left;
            Class<?> componentType;
            block9: {
                block8: {
                    block7: {
                        if (this.eq(left, right)) {
                            return true;
                        }
                        if (null == left || this.isEmpty(right)) break block6;
                        if (!(right instanceof Iterable)) break block7;
                        Iterator itor = ((Iterable)right).iterator();
                        while (itor.hasNext()) {
                            if (!this.eq(left, itor.next())) continue;
                            return true;
                        }
                        break block6;
                    }
                    if (!right.getClass().isArray()) break block6;
                    componentType = right.getClass().getComponentType();
                    if (!componentType.isInstance(left)) break block8;
                    int end_i = Array.getLength(right);
                    for (int i = 0; i < end_i; ++i) {
                        if (!left.equals(Array.get(right, i))) continue;
                        return true;
                    }
                    break block6;
                }
                if (!(left instanceof String)) break block6;
                if (!Number.class.isAssignableFrom(componentType)) break block9;
                try {
                    Object _left2 = JSON.parseObject((String)((String)left), componentType, (ParserConfig)ParserConfig.global, null, (int)0, (Feature[])new Feature[0]);
                    return this.eqin(_left2, right);
                }
                catch (JSONException _left2) {}
                break block6;
            }
            if (!Date.class.isAssignableFrom(componentType) || null == (_left = DateSupport.getDateFromString((String)((String)left), pattern = new AtomicReference(), (int[])new int[0]))) break block6;
            SimpleDateFormat fmt = new SimpleDateFormat((String)pattern.get());
            int end_i = Array.getLength(right);
            for (int i = 0; i < end_i; ++i) {
                if (!left.equals(fmt.format((Date)Array.get(right, i)))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean eq(Object left, Object right) {
        if (Objects.equals(left, right)) {
            return true;
        }
        if (null != left && null != right) {
            if (left.getClass().isInstance(right) || left.getClass().isInstance(right)) {
                return false;
            }
            if (left instanceof String) {
                AtomicReference pattern;
                Date _left;
                if (right instanceof Number) {
                    try {
                        Object _var = JSON.parseObject((String)((String)left), right.getClass(), (ParserConfig)ParserConfig.global, null, (int)0, (Feature[])new Feature[0]);
                        return this.eq(_var, right);
                    }
                    catch (JSONException _var) {}
                } else if (right instanceof Date && null != (_left = DateSupport.getDateFromString((String)((String)left), pattern = new AtomicReference(), (int[])new int[0]))) {
                    return left.equals(new SimpleDateFormat((String)pattern.get()).format((Date)right));
                }
            }
        }
        return false;
    }

    public String likeOp(String like_op, String pattern) {
        switch (like_op) {
            case "LEFT": {
                return "'" + pattern + "%'";
            }
            case "RIGHT": {
                return "'%" + pattern + "'";
            }
        }
        return "'%" + pattern + "%'";
    }

    public String join(Object input, String separator) {
        if (input instanceof String) {
            return (String)((Object)input);
        }
        if (input instanceof String[]) {
            input = Arrays.asList((String[])input);
        }
        if (input instanceof Collection) {
            String sep = (String)MoreObjects.firstNonNull((Object)separator, (Object)",");
            return (String)((Collection)input).stream().map(o -> (String)BeanShellWhereBuilder.getFormatJsonFieldFunction().apply((Object)String.valueOf(o))).reduce((l, r) -> String.valueOf(l) + sep + String.valueOf(r)).orElse("");
        }
        return String.valueOf(input);
    }

    private int appendValue(StringBuilder result, Object value) {
        if (null == value) {
            result.append("NULL");
            return 1;
        }
        if (value.getClass().isArray() && 1 == Array.getLength(value)) {
            this.appendValue(result, Array.get(value, 0));
            return 1;
        }
        if (value instanceof boolean[]) {
            this.appendInBraces(result, Arrays.toString((boolean[])value));
            return Array.getLength(value);
        }
        if (value instanceof byte[]) {
            this.appendInBraces(result, Arrays.toString((byte[])value));
            return Array.getLength(value);
        }
        if (value instanceof short[]) {
            this.appendInBraces(result, Arrays.toString((short[])value));
            return Array.getLength(value);
        }
        if (value instanceof int[]) {
            this.appendInBraces(result, Arrays.toString((int[])value));
            return Array.getLength(value);
        }
        if (value instanceof long[]) {
            this.appendInBraces(result, Arrays.toString((long[])value));
            return Array.getLength(value);
        }
        if (value instanceof float[]) {
            this.appendInBraces(result, Arrays.toString((float[])value));
            return Array.getLength(value);
        }
        if (value instanceof double[]) {
            this.appendInBraces(result, Arrays.toString((double[])value));
            return Array.getLength(value);
        }
        if (value instanceof char[]) {
            this.appendInBraces(result, Arrays.toString((char[])value));
            return Array.getLength(value);
        }
        if (value instanceof Object[]) {
            result.append('(');
            int c = 0;
            for (Object v : (Object[])value) {
                if (c++ > 0) {
                    result.append(',');
                }
                this.appendValue(result, v);
            }
            result.append(')');
            return c;
        }
        if (value instanceof Iterator) {
            result.append('(');
            int c = 0;
            Iterator itor = (Iterator)value;
            while (itor.hasNext()) {
                if (c++ > 0) {
                    result.append(',');
                }
                this.appendValue(result, itor.next());
            }
            result.append(')');
            return c;
        }
        if (value instanceof Iterable) {
            return this.appendValue(result, ((Iterable)value).iterator());
        }
        if (value instanceof String) {
            result.append("'").append(value).append("'");
        } else if (value instanceof Date) {
            result.append("'").append(new SimpleDateFormat(this.timeFormatter).format((Date)value)).append("'");
        } else {
            result.append(value);
        }
        return 1;
    }

    private static String escape(String input) {
        if (null == input) {
            return null;
        }
        int stringLength = input.length();
        boolean escaped = false;
        StringBuilder buf = new StringBuilder((int)((double)input.length() * 1.1));
        block9: for (int i = 0; i < stringLength; ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\u0000': {
                    buf.append('\\');
                    buf.append('0');
                    escaped = true;
                    continue block9;
                }
                case '\n': {
                    buf.append('\\');
                    buf.append('n');
                    escaped = true;
                    continue block9;
                }
                case '\r': {
                    buf.append('\\');
                    buf.append('r');
                    escaped = true;
                    continue block9;
                }
                case '\\': {
                    buf.append('\\');
                    buf.append('\\');
                    escaped = true;
                    continue block9;
                }
                case '\'': {
                    buf.append('\\');
                    buf.append('\'');
                    escaped = true;
                    continue block9;
                }
                case '\"': {
                    buf.append('\\');
                    buf.append('\"');
                    escaped = true;
                    continue block9;
                }
                case '\u001a': {
                    buf.append('\\');
                    buf.append('Z');
                    escaped = true;
                    continue block9;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return escaped ? buf.toString() : input;
    }

    private static Object escape(Object input) {
        block5: {
            block4: {
                if (input instanceof String) {
                    return WhereHelper.escape((String)input);
                }
                if (!(input instanceof Iterator)) break block4;
                ArrayList<Object> list = new ArrayList<Object>();
                Iterator itor = (Iterator)input;
                while (itor.hasNext()) {
                    list.add(WhereHelper.escape(itor.next()));
                }
                break block5;
            }
            if (input instanceof Iterable) {
                return WhereHelper.escape(((Iterable)input).iterator());
            }
            if (null == input || !input.getClass().isArray()) break block5;
            int end_i = Array.getLength(input);
            for (int i = 0; i < end_i; ++i) {
                Array.set(input, i, WhereHelper.escape(Array.get(input, i)));
            }
        }
        return input;
    }

    private void appendInBraces(StringBuilder buf, String s) {
        buf.append('(').append(s.substring(1, s.length() - 1)).append(')');
    }

    private String stringOf(Object value, AtomicInteger sizeOut) {
        StringBuilder builder = new StringBuilder();
        int size = this.appendValue(builder, value);
        if (null != sizeOut) {
            sizeOut.set(size);
        }
        return builder.toString();
    }

    public String asCond(Object value, boolean not) {
        if (null == value) {
            return "IS " + (not ? "NOT " : "") + "NULL";
        }
        AtomicInteger sizeOut = new AtomicInteger(0);
        String string = this.stringOf(value, sizeOut);
        if (sizeOut.get() > 1) {
            return String.format("%sIN %s", not ? "NOT " : "", string);
        }
        return String.format("%s= %s", not ? "!" : "", string);
    }

    private Object valueOf(Object obj, String field) {
        try {
            return this.propertyUtils.getProperty(obj, field);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    private void initVarIfNotdefined(String varname, Object defaultValue, boolean camelCase) throws EvalError {
        if (!Strings.isNullOrEmpty((String)varname)) {
            String camelCaseName;
            if (null == this.interpreter.get(varname)) {
                this.interpreter.set(varname, defaultValue);
            } else if (camelCase && !(camelCaseName = WhereHelpers.toCamelcase(varname)).equals(varname)) {
                this.interpreter.set(camelCaseName, this.interpreter.get(varname));
            }
        }
    }

    private String isRefVar(String varname) {
        if (this.referenceVariables.contains(varname)) {
            return varname;
        }
        String v = WhereHelpers.toCamelcase(varname);
        if (this.referenceVariables.contains(v)) {
            return v;
        }
        v = WhereHelpers.toSnakecase(varname);
        if (this.referenceVariables.contains(v)) {
            return v;
        }
        return null;
    }

    private void initVars(Object params) {
        try {
            if (params instanceof Map) {
                Map m = (Map)params;
                for (Map.Entry entry : m.entrySet()) {
                    String refVar;
                    if (!(entry.getKey() instanceof String) || null == (refVar = this.isRefVar((String)entry.getKey()))) continue;
                    Object value = entry.getValue();
                    this.interpreter.set(WhereHelper.checkVarName(refVar), WhereHelper.escape(value));
                    SimpleLog.log((boolean)this.debuglog, (String)"variable {}={}", (Object[])new Object[]{refVar, value});
                }
            } else {
                Map<String, PropertyDescriptor> props = BeanPropertyUtils.getProperties(params.getClass(), 3, true);
                for (String field : props.keySet()) {
                    String refVar = this.isRefVar(field);
                    if (null == refVar) continue;
                    Object value = this.valueOf(params, field);
                    this.interpreter.set(WhereHelper.checkVarName(refVar), WhereHelper.escape(value));
                    SimpleLog.log((boolean)this.debuglog, (String)"variable {}={}", (Object[])new Object[]{refVar, value});
                }
            }
        }
        catch (EvalError e) {
            throw new RuntimeException(e);
        }
    }

    private void formatJsonFieldInVar(String varname) throws EvalError {
        String v;
        Object ov;
        Object object = ov = null == varname ? null : this.interpreter.get(varname);
        if (ov instanceof String && !ov.equals(v = (String)BeanShellWhereBuilder.getFormatJsonFieldFunction().apply((Object)String.valueOf(ov)))) {
            this.interpreter.set(varname, (Object)WhereHelper.escape(v));
        }
    }

    private void beforeWhere() throws EvalError {
        for (String varname : BUILTIN_VARS) {
            this.initVarIfNotdefined(varname, null, true);
        }
        this.formatJsonFieldInVar(this.orderByVar);
        this.formatJsonFieldInVar(this.groupByVar);
        this.initVarIfNotdefined(this.orderByVar, this.defaultOrderByColumns, false);
        this.initVarIfNotdefined(this.groupByVar, this.defaultGroupByColumns, false);
    }

    private void unsetVars() throws EvalError {
        for (String varname : Arrays.asList(this.interpreter.getNameSpace().getVariableNames())) {
            if (KEYWORD_BSH.equals(varname)) continue;
            SimpleLog.log((boolean)this.debuglog, (String)"unset {}", (Object[])new Object[]{varname});
            this.interpreter.unset(varname);
        }
    }

    private Class<?> variableTypeOf(String varname) {
        if (!Strings.isNullOrEmpty((String)varname)) {
            RowMetaData metaData = RowMetaData.getMetaDataUnchecked(this.targetClass);
            if (null != metaData) {
                Class type = metaData.columnTypeOf(varname);
                if (null != type) {
                    return type;
                }
                return metaData.columnTypeOf(WhereHelpers.toCamelcase(varname));
            }
            Class<?> type = this.varTypes.get(varname);
            if (null != type) {
                return type;
            }
            if (WhereHelpers.isCamelcase(varname)) {
                return this.varTypes.get(WhereHelpers.toSnakecase(varname));
            }
            if (WhereHelpers.isSnakelcase(varname)) {
                return this.varTypes.get(WhereHelpers.toCamelcase(varname));
            }
        }
        return null;
    }

    public static Object guess(Object obj, Class<?> expectType) {
        if (obj instanceof String) {
            String value = ((String)obj).trim();
            if (!Strings.isNullOrEmpty((String)value)) {
                if (null != expectType) {
                    if (value.startsWith("[")) {
                        if (String.class.equals(expectType) && value.endsWith("]") && value.indexOf(34) < 0) {
                            String v = value.replaceAll("^\\[", "").replaceAll("\\]$", "");
                            return Arrays.stream(v.split("(\\s*[,]\\s*)+")).filter(s -> !s.isEmpty()).toArray(String[]::new);
                        }
                        return JSON.parseObject((String)value, Array.newInstance(expectType, 0).getClass(), (ParserConfig)ParserConfig.global, null, (int)0, (Feature[])new Feature[0]);
                    }
                    if (Primitives.unwrap(expectType).isPrimitive() && value.indexOf(44) >= 0) {
                        value = "[" + Pattern.compile("(^,|,$)", 2).matcher(value).replaceAll("") + "]";
                        return JSON.parseObject((String)value, Array.newInstance(expectType, 0).getClass(), (ParserConfig)ParserConfig.global, null, (int)0, (Feature[])new Feature[0]);
                    }
                    if (String.class.equals(expectType)) {
                        if (value.indexOf(44) >= 0) {
                            return Arrays.stream(value.split("(\\s*[,]\\s*)+")).filter(s -> !s.isEmpty()).toArray(String[]::new);
                        }
                        return value;
                    }
                    return JSON.parseObject((String)value, expectType, (ParserConfig)ParserConfig.global, null, (int)0, (Feature[])new Feature[0]);
                }
                try {
                    if (value.trim().startsWith("[")) {
                        return JSON.parseObject((String)value, JSONArray.class, (ParserConfig)ParserConfig.global, null, (int)0, (Feature[])new Feature[0]);
                    }
                    if (value.indexOf(44) >= 0) {
                        return Arrays.stream(value.split("(\\s*[,]\\s*)+")).filter(s -> !s.isEmpty()).toArray(String[]::new);
                    }
                }
                catch (JSONException jSONException) {}
            }
        } else if (obj != null && null != expectType) {
            Preconditions.checkArgument((obj instanceof Iterable || obj.getClass().isArray() || expectType.isInstance(obj) ? 1 : 0) != 0, (String)"obj (%s) is not exprected type %s", (Object)obj.getClass().getName(), (Object)expectType.getName());
        }
        return obj;
    }

    private static String checkVarName(String varname) {
        Preconditions.checkArgument((!KEYWORDS.contains(varname) ? 1 : 0) != 0, (String)"'%s' must not be a variable name,because it is protected keyword of WhereHelper or BeanShell", (Object)varname);
        return varname;
    }

    public static BeanShellWhereBuilder builder() {
        return new BeanShellWhereBuilder();
    }

    public String toString() {
        return "WhereHelper [" + (this.timeFormatter != null ? "timeFormatter=" + this.timeFormatter + ", " : "") + (this.bshScript != null ? "script=" + this.bshScript : "") + "]";
    }
}

