/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.wherehelper;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import gu.sql2java.wherehelper.WhereHelper;
import gu.sql2java.wherehelper.annotations.EnableWhereHelper;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;

public class WhereHelpers {
    private WhereHelpers() {
    }

    public static String toSnakecase(String name) {
        return null == name ? name : CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
    }

    public static String toCamelcase(String name) {
        return null == name ? name : CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
    }

    public static boolean isCamelcase(String name) {
        return null == name ? false : name.equals(WhereHelpers.toCamelcase(name));
    }

    public static boolean isSnakelcase(String name) {
        return null == name ? false : name.equals(WhereHelpers.toSnakecase(name));
    }

    public static WhereHelper buildWhereHelperIfEnable(Method method, Object[] args, Function<String, String> valueSupplier) {
        EnableWhereHelper enableWhereHelper;
        if (null != method && null != (enableWhereHelper = method.getAnnotation(EnableWhereHelper.class)) && enableWhereHelper.enable()) {
            HashMap m = Maps.newHashMap();
            Parameter[] params = method.getParameters();
            if (params.length > 0) {
                Preconditions.checkArgument((null != args && params.length == args.length ? 1 : 0) != 0, (String)"args must not be null and length == %s", (int)params.length);
                for (int i = 0; i < params.length; ++i) {
                    m.put(params[i].getName(), args[i]);
                }
            }
            return WhereHelper.builder().from(method.getAnnotations()).pagequery(false).build().with(m).with(valueSupplier);
        }
        return null;
    }
}

