package gu.sql2java.store;

import static gu.sql2java.store.BinaryUtils.*;

import java.io.IOException;
import java.net.URL;

/**
 * 二进制数据对象定义 
 * @author guyadong
 *
 */
public class URLInfo {
    /**
     * 数据文件位置
     */
	public URL location=null;

    /**
     * 文件后缀
     */
	public String extension=null;

	private volatile String md5;
	private URLInfo() {		
	}
    /**
     * 返回二进制数据MD5
     * @return 二进制数据MD5
     */
	public String getMD5(){
		if( null == md5){
			synchronized (this) {
				if( null == md5){
					try {
						md5 = location == null ? null : getMD5String(getBytes(location));
					} catch (DataNotFoundException e) {
						// DO NOTHING
					}catch (IOException e) {
						throw new IllegalArgumentException(e);
					}
				}
			}
		}
		return md5;
	}
	/**
	 * 填充{@link URLInfo}相关字段字段<br>
	 * {@link URLInfo#location}和imgURL不能 同时为null,否则抛出{@link IllegalArgumentException}
	 * @param url 数据位置
	 * @param annImage
	 * @return 
	 */
	URLInfo fill(URL url) {
		if(null == url){
			throw new NullPointerException("url is null");
		}
		location = url;
		try{
			int lastDot = url.getFile().lastIndexOf('.');
			extension = lastDot < 0 ? null :  url.getFile().substring(lastDot + 1);
		}catch (IndexOutOfBoundsException e) {
			extension = null;
		}			
		return this;
	}
	/**
	 * 根据{@link URL}创建{@link URLInfo}对象,填充必要的图像参数字段<br>
	 * 异常封装到{@link RuntimeException}抛出
	 * @param url
	 * @return
	 * @see {@link #fill(URL, URLInfo)}
	 */
	public static URLInfo wrap(URL url) {
		return new URLInfo().fill(url);
	}

}
