/*
 * Decompiled with CFR 0.152.
 */
package ref.org.apache.commons.jnet;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import ref.org.apache.commons.jnet.ParentAwareURLStreamHandlerFactory;
import ref.org.apache.commons.jnet.URLStreamHandlerFactoryWrapper;

public class DynamicURLStreamHandlerFactory
extends ParentAwareURLStreamHandlerFactory {
    protected static final ThreadLocal<URLStreamHandlerFactory> FACTORY = new InheritableThreadLocal<URLStreamHandlerFactory>();

    public static void push(URLStreamHandlerFactory factory) {
        if (!(factory instanceof ParentAwareURLStreamHandlerFactory)) {
            factory = new URLStreamHandlerFactoryWrapper(factory);
        }
        URLStreamHandlerFactory old = FACTORY.get();
        ((ParentAwareURLStreamHandlerFactory)factory).setParentFactory(old);
        FACTORY.set(factory);
    }

    public static void pop() {
        ParentAwareURLStreamHandlerFactory factory = (ParentAwareURLStreamHandlerFactory)FACTORY.get();
        if (factory != null) {
            FACTORY.set(factory.getParent());
        }
    }

    @Override
    protected URLStreamHandler create(String protocol) {
        ParentAwareURLStreamHandlerFactory factory = (ParentAwareURLStreamHandlerFactory)FACTORY.get();
        if (factory != null) {
            return factory.createURLStreamHandler(protocol);
        }
        return null;
    }
}

