/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.store;

import gu.sql2java.store.BinaryUtils;
import gu.sql2java.store.URLInfo;
import gu.sql2java.store.URLStore;
import java.io.IOException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import ref.org.apache.commons.jnet.Installer;

public abstract class BaseURLStore
implements URLStreamHandlerFactory,
URLStore {
    private volatile boolean installed = false;
    private final Map<String, Class<?>> optionalParamTypes = new Hashtable();
    protected final ThreadLocal<Map<String, Object>> additionalParams = new ThreadLocal();

    protected BaseURLStore() {
        this(null);
    }

    protected BaseURLStore(Map<String, Class<?>> optionalParamTypes) {
        if (optionalParamTypes == null) {
            optionalParamTypes = Collections.emptyMap();
        }
        this.optionalParamTypes.putAll(optionalParamTypes);
    }

    protected abstract URL doStore(byte[] var1, String var2, String var3, boolean var4) throws IOException;

    protected abstract boolean doExists(URL var1);

    protected abstract URL doFind(String var1);

    protected abstract boolean doDelete(URL var1) throws IOException;

    protected abstract URLStreamHandler doGetURLStreamHandler();

    protected final URL find(URLInfo binary) {
        if (this.isStored(binary.location)) {
            return this.doExists(binary.location) ? binary.location : null;
        }
        String md5 = binary.getMD5();
        return md5 == null ? null : this.doFind(md5);
    }

    @Override
    public final boolean isStored(URL url) {
        return null != url && url.getProtocol().equals(this.getProtocol());
    }

    @Override
    public final boolean exists(URL url) {
        return null != this.find(URLInfo.wrap(url));
    }

    @Override
    public final <T> URL store(T input, String md5, String extension, boolean overwrite, boolean makeURLOnly) throws IOException {
        byte[] binary;
        if (makeURLOnly) {
            binary = BinaryUtils.getBytes(input);
            if (!BinaryUtils.validMd5(md5)) {
                throw new IOException("VALID md5 required while make URL only");
            }
        } else {
            binary = BinaryUtils.getBytesNotEmpty(input);
            if (!BinaryUtils.validMd5(md5)) {
                md5 = BinaryUtils.getMD5String(binary);
            }
        }
        return this.doStore(binary, md5, extension, makeURLOnly);
    }

    @Override
    public final boolean delete(String md5) throws IOException {
        URL storedURL;
        if (BinaryUtils.validMd5(md5) && null != (storedURL = this.doFind(md5))) {
            return this.doDelete(storedURL);
        }
        return false;
    }

    @Override
    public final URL store(URL url, boolean overwrite, boolean makeURLOnly) throws IOException {
        URLInfo data = URLInfo.wrap(url);
        URL storedURL = this.find(data);
        if (null == storedURL || overwrite) {
            storedURL = this.doStore(BinaryUtils.getBytesNotEmpty(data.location), data.getMD5(), data.extension, makeURLOnly);
        }
        return storedURL;
    }

    @Override
    public final boolean delete(URL url) throws IOException {
        URL storedURL = url;
        if (!this.isStored(storedURL) && null == (storedURL = this.find(URLInfo.wrap(url)))) {
            return false;
        }
        return this.doDelete(storedURL);
    }

    @Override
    public final BaseURLStore setAdditionalParam(String name, Object value) {
        Class<?> type;
        if (null != name && null != (type = this.optionalParamTypes.get(name)) && null != value) {
            if (!type.isInstance(value)) {
                throw new IllegalArgumentException(String.format("INVALID  param type for %s , %srequired", name, type));
            }
            if (this.additionalParams.get() == null) {
                this.additionalParams.set(new HashMap());
            }
            this.additionalParams.get().put(name, value);
        }
        return this;
    }

    @Override
    public final URLStreamHandler createURLStreamHandler(String protocol) {
        if (this.getProtocol().equals(protocol)) {
            return this.doGetURLStreamHandler();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BaseURLStore intall() throws Exception {
        if (!this.installed) {
            BaseURLStore baseURLStore = this;
            synchronized (baseURLStore) {
                if (!this.installed) {
                    Installer.setURLStreamHandlerFactory(this);
                    this.installed = true;
                }
            }
        }
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseURLStore)) {
            return false;
        }
        BaseURLStore other = (BaseURLStore)obj;
        return !(this.getProtocol() == null ? other.getProtocol() != null : !this.getProtocol().equals(other.getProtocol()));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BaseURLStore [protocol=");
        builder.append(this.getProtocol());
        builder.append("]");
        return builder.toString();
    }
}

