/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.store;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nullable;

public class ConditionChecks {
    private ConditionChecks() {
    }

    public static <X extends Throwable> void checkTrue(boolean b, Class<X> declareType, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) throws X {
        if (!b) {
            try {
                if (declareType == null) {
                    throw new NullPointerException("declareType is null");
                }
                throw (Throwable)declareType.getConstructor(String.class).newInstance(ConditionChecks.format(errorMessageTemplate, errorMessageArgs));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static <X extends Throwable> void checkTrue(boolean b, Class<X> declareType, @Nullable String errorMessageTemplate, @Nullable Object p1) throws X {
        if (!b) {
            try {
                if (declareType == null) {
                    throw new NullPointerException("declareType is null");
                }
                throw (Throwable)declareType.getConstructor(String.class).newInstance(ConditionChecks.format(errorMessageTemplate, p1));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @CanIgnoreReturnValue
    public static <T, X extends Throwable> T checkNotNull(T reference, Class<X> declareType, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) throws X {
        if (null == reference) {
            try {
                if (declareType == null) {
                    throw new NullPointerException("declareType is null");
                }
                throw (Throwable)declareType.getConstructor(String.class).newInstance(ConditionChecks.format(errorMessageTemplate, errorMessageArgs));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T, X extends Throwable> T checkNotNull(T reference, Class<X> declareType, @Nullable String errorMessageTemplate, @Nullable Object p1) throws X {
        if (null == reference) {
            try {
                if (declareType == null) {
                    throw new NullPointerException("declareType is null");
                }
                throw (Throwable)declareType.getConstructor(String.class).newInstance(ConditionChecks.format(errorMessageTemplate, p1));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return reference;
    }

    static String format(String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template, templateStart, template.length());
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }
}

