/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.store;

import gu.sql2java.store.BaseURLStore;
import gu.sql2java.store.BinaryUtils;
import gu.sql2java.store.ConditionChecks;
import gu.sql2java.store.DataNotFoundException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public class LocalBinaryStore
extends BaseURLStore {
    private static final String ORIGIN_ROOT_NAME = "origin";
    private static final String PROTOCOL = "lbs";
    private final URLStreamHandler handler = new Handler();
    private File storeRoot;
    public static final LocalBinaryStore SINGLETON = new LocalBinaryStore();

    private LocalBinaryStore() {
    }

    protected URL createStoreURL(File file) {
        try {
            return new URL(PROTOCOL, null, file.toURI().toURL().getPath().substring(this.getStoreRoot().toURI().toURL().getPath().length()));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean doExists(URL storedURL) {
        return this.pathOf(storedURL).canRead();
    }

    @Override
    protected URL doFind(final String md5) {
        File folder = this.relativeFolderPath(md5);
        if (folder.isDirectory()) {
            File[] files = folder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(md5);
                }
            });
            try {
                return files.length > 0 ? files[0].toURI().toURL() : null;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    protected File pathOf(URL storedURL) {
        return new File(this.getStoreRoot().getPath(), storedURL.getPath());
    }

    @Override
    protected URL doStore(byte[] binary, String md5, String extension, boolean makeURLOnly) throws IOException {
        File dst = this.createDestFile(md5, extension);
        if (!makeURLOnly && dst.length() != (long)binary.length) {
            BinaryUtils.saveBytes(binary, dst, true);
        }
        return this.createStoreURL(dst);
    }

    @Override
    protected boolean doDelete(URL storedURL) throws IOException {
        File p = this.pathOf(storedURL);
        if (p.exists()) {
            return p.delete();
        }
        return false;
    }

    @Override
    public final String getProtocol() {
        return PROTOCOL;
    }

    public LocalBinaryStore setStoreRoot(File storeRoot) {
        this.storeRoot = storeRoot;
        return this;
    }

    private File getStoreRoot() {
        return ConditionChecks.checkNotNull(this.storeRoot, IllegalStateException.class, "storeRoot is uninitialized,please call setStoreRoot(File) firstly", new Object[0]);
    }

    protected String relativeFilePath(String md5, String suffix) {
        String s = suffix == null || suffix.length() == 0 ? "" : "." + suffix;
        File f = new File(new File(new File(ORIGIN_ROOT_NAME, md5.substring(0, 2)), md5.substring(2, 4)), md5 + s);
        return f.toString();
    }

    protected File relativeFolderPath(String md5) {
        return new File(new File(ORIGIN_ROOT_NAME, md5.substring(0, 2)), md5.substring(2, 4));
    }

    private File createDestFile(String md5, String suffix) {
        return new File(this.getStoreRoot(), this.relativeFilePath(md5, suffix));
    }

    @Override
    protected URLStreamHandler doGetURLStreamHandler() {
        return this.handler;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        result = 31 * result + (this.storeRoot == null ? 0 : this.storeRoot.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LocalBinaryStore)) {
            return false;
        }
        LocalBinaryStore other = (LocalBinaryStore)obj;
        if (this.getProtocol() == null ? other.getProtocol() != null : !this.getProtocol().equals(other.getProtocol())) {
            return false;
        }
        return !(this.storeRoot == null ? other.storeRoot != null : !this.storeRoot.equals(other.storeRoot));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LocalBinaryStore [protocol=");
        builder.append(this.getProtocol());
        builder.append(",storeRoot=");
        builder.append(this.storeRoot);
        builder.append("]");
        return builder.toString();
    }

    private class FileConnection
    extends URLConnection {
        protected FileConnection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
            this.connected = true;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            try {
                return new FileInputStream(LocalBinaryStore.this.pathOf(this.url));
            }
            catch (FileNotFoundException e) {
                throw new DataNotFoundException(this.url, (Throwable)e);
            }
        }
    }

    private class Handler
    extends URLStreamHandler {
        private Handler() {
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new FileConnection(u);
        }
    }
}

