/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.store;

import gu.sql2java.store.BaseURLStore;
import gu.sql2java.store.ConditionChecks;
import gu.sql2java.store.DataNotFoundException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public abstract class BasesLocalBinaryStore
extends BaseURLStore {
    static final String PROTOCOL = "lbs";
    private final URLStreamHandler handler = new Handler();
    protected File storeRoot;

    public BasesLocalBinaryStore(File storeRoot) {
        this.storeRoot = storeRoot;
    }

    public BasesLocalBinaryStore(String storeRoot) {
        this(new File(storeRoot));
    }

    @Override
    protected boolean doExists(URL storedURL) {
        return this.pathOf(storedURL).canRead();
    }

    protected File pathOf(URL storedURL) {
        return new File(this.getStoreRoot().getPath(), storedURL.getPath());
    }

    @Override
    protected boolean doDelete(URL storedURL) throws IOException {
        File p = this.pathOf(storedURL);
        if (p.exists()) {
            return p.delete();
        }
        return false;
    }

    @Override
    public final String getProtocol() {
        return PROTOCOL;
    }

    public URL asNativeUrl(URL storedUrl) {
        if (this.isStored(storedUrl)) {
            try {
                return this.pathOf(storedUrl).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    protected File getStoreRoot() {
        return ConditionChecks.checkNotNull(this.storeRoot, IllegalStateException.class, "storeRoot is uninitialized,please call setStoreRoot(File) firstly", new Object[0]);
    }

    @Override
    protected URLStreamHandler doGetURLStreamHandler() {
        return this.handler;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        result = 31 * result + (this.storeRoot == null ? 0 : this.storeRoot.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof BasesLocalBinaryStore)) {
            return false;
        }
        BasesLocalBinaryStore other = (BasesLocalBinaryStore)obj;
        if (this.getProtocol() == null ? other.getProtocol() != null : !this.getProtocol().equals(other.getProtocol())) {
            return false;
        }
        return !(this.storeRoot == null ? other.storeRoot != null : !this.storeRoot.equals(other.storeRoot));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LocalBinaryStore [protocol=");
        builder.append(this.getProtocol());
        builder.append(",storeRoot=");
        builder.append(this.storeRoot);
        builder.append("]");
        return builder.toString();
    }

    private class FileConnection
    extends URLConnection {
        protected FileConnection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
            this.connected = true;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            try {
                return new FileInputStream(BasesLocalBinaryStore.this.pathOf(this.url));
            }
            catch (FileNotFoundException e) {
                throw new DataNotFoundException(this.url, (Throwable)e);
            }
        }
    }

    private class Handler
    extends URLStreamHandler {
        private Handler() {
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new FileConnection(u);
        }
    }
}

