/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.store;

import gu.sql2java.store.BasesLocalBinaryStore;
import gu.sql2java.store.LocalBinaryStore;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class MultiLocalStore
extends BasesLocalBinaryStore {
    private final ConcurrentHashMap<String, LocalBinaryStore> stores = new ConcurrentHashMap();

    public MultiLocalStore(File storeRoot) {
        super(storeRoot);
    }

    public MultiLocalStore(String storeRoot) {
        super(storeRoot);
    }

    public void addPartition(String partition, int level) {
        this.addPartition(partition, new LocalBinaryStore(this.storeRoot, partition, level));
    }

    public void addPartition(String partition, LocalBinaryStore localBinaryStore) {
        if (null == partition || partition.length() == 0) {
            throw new IllegalArgumentException("partition is null or empty");
        }
        if (null == localBinaryStore) {
            throw new NullPointerException("localBinaryStore is null");
        }
        if (!Objects.equals(this.getStoreRoot(), localBinaryStore.getStoreRoot())) {
            throw new IllegalArgumentException(String.format("MISMATCH storeRoot %s VS %s", this.getStoreRoot(), localBinaryStore.getStoreRoot()));
        }
        this.stores.putIfAbsent(partition, localBinaryStore);
    }

    public LocalBinaryStore getStore(String partition) {
        return this.stores.get(partition);
    }

    public <T> URL store(String partition, T binary, String md5, String extension, boolean overwrite, boolean makeURLOnly) throws IOException {
        LocalBinaryStore store = this.stores.get(partition);
        if (null == store) {
            throw new IllegalArgumentException("INVALID partition=" + partition);
        }
        return store.store(binary, md5, extension, overwrite, makeURLOnly);
    }

    @Override
    protected URL doStore(byte[] binary, String md5, String extension, boolean overwrite, boolean makeURLOnly) throws IOException {
        throw new UnsupportedOperationException("UNSUPPORTED method, replace with store(String,  Object, String, String, boolean, boolean)");
    }

    @Override
    protected URL doFind(String md5) {
        for (LocalBinaryStore store : this.stores.values()) {
            URL url = store.doFind(md5);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.stores);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiLocalStore other = (MultiLocalStore)obj;
        return Objects.equals(this.stores, other.stores);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MultiLocalStore [stores=").append(this.stores).append("]");
        return builder.toString();
    }
}

