/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.store;

import gu.sql2java.store.BasesLocalBinaryStore;
import gu.sql2java.store.BinaryUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocalBinaryStore
extends BasesLocalBinaryStore {
    private static final String ORIGIN_ROOT_NAME = "origin";
    public static final String PROTOCOL = "lbs";
    public static final LocalBinaryStore SINGLETON = new LocalBinaryStore();
    private final String partition;
    private final String _spartition;
    private final int level;
    private volatile Integer rootPathLength;

    private LocalBinaryStore() {
        this((File)null, ORIGIN_ROOT_NAME, 2);
    }

    public LocalBinaryStore(File storeRoot, String partition, int level) {
        super(storeRoot);
        this.partition = null == partition || partition.length() == 0 ? ORIGIN_ROOT_NAME : partition;
        this._spartition = LocalBinaryStore.slashify(partition, true);
        this.level = level < 0 || level > 4 ? 2 : level;
    }

    public LocalBinaryStore(String storeRoot, String partition, int level) {
        this(new File(storeRoot), partition, level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRootPathLength() {
        if (this.rootPathLength == null) {
            LocalBinaryStore localBinaryStore = this;
            synchronized (localBinaryStore) {
                if (this.rootPathLength == null) {
                    this.rootPathLength = LocalBinaryStore.slashify(this.getStoreRoot().getAbsolutePath(), true).length();
                }
            }
        }
        return this.rootPathLength;
    }

    protected URL createStoreURL(File file) {
        try {
            String path = LocalBinaryStore.slashify(file.getAbsolutePath(), false);
            return new URL(PROTOCOL, null, LocalBinaryStore.slashify(path.substring(this.getRootPathLength()), false));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected URL doFind(final String md5) {
        File folder = this.localFolderOf(md5);
        if (folder.isDirectory()) {
            File[] files = folder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(md5);
                }
            });
            return files.length > 0 ? this.createStoreURL(files[0]) : null;
        }
        return null;
    }

    @Override
    protected URL doStore(byte[] binary, String md5, String extension, boolean overwrite, boolean makeURLOnly) throws IOException {
        File dst = this.createDestFile(md5, extension);
        if (!(makeURLOnly || dst.length() == (long)binary.length || dst.isFile() && !overwrite)) {
            BinaryUtils.saveBytes(binary, dst, true);
        }
        return this.createStoreURL(dst);
    }

    public String asRelativePath(URL storedUrl, String prefix) {
        if (null != storedUrl) {
            String path = storedUrl.getPath();
            if (null != prefix && prefix.length() > 0) {
                path = LocalBinaryStore.slashify(prefix, true) + path.substring(this._spartition.length());
            }
            return path;
        }
        return null;
    }

    public URL asCanonicalURL(URL storedUrl, String protocol, String host, Integer port, String prefix) {
        if (null == host) {
            throw new NullPointerException("hostAndPort is null");
        }
        String path = this.asRelativePath(storedUrl, prefix);
        if (null != path) {
            if (null == protocol) {
                protocol = "http";
            }
            try {
                if (null != port && port > 0) {
                    return new URL(protocol, host, port, path);
                }
                return new URL(protocol, host, path);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public URL asStoredURL(URL canonicalUrl) {
        String path;
        if (null != canonicalUrl && (path = canonicalUrl.getPath()) != null) {
            int rpos = this.matchRelativePath(path);
            if (rpos >= 0) {
                path = this._spartition + path.substring(rpos);
            }
            try {
                return new URL(PROTOCOL, null, path);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public LocalBinaryStore setStoreRoot(File storeRoot) {
        this.storeRoot = storeRoot;
        return this;
    }

    public String getPartition() {
        return this.partition;
    }

    private Path levelFolderOf(String prefix, String md5) {
        String[] subfolders = new String[this.level];
        int i = 0;
        int j = 0;
        while (i < this.level) {
            subfolders[i] = md5.substring(j, j + 2);
            ++i;
            j += 2;
        }
        return Paths.get(prefix, subfolders);
    }

    protected String relativeFilePath(String md5, String suffix) {
        String s = suffix == null || suffix.length() == 0 ? "" : (suffix.charAt(0) != '.' ? "." + suffix : suffix);
        Path p = Paths.get(this.levelFolderOf(this._spartition, md5).toString(), md5 + s);
        return p.toString();
    }

    protected File localFolderOf(String md5) {
        return Paths.get(this.getStoreRoot().getAbsolutePath(), this.levelFolderOf(this._spartition, md5).toString()).toFile();
    }

    protected int matchRelativePath(String path) {
        Matcher matcher;
        if (null != path && path.length() > 0 && (matcher = Pattern.compile("([\\da-f]{2}/){" + this.level + "}[\\da-f]{32}(\\.\\w*)?$").matcher(path)).find()) {
            return matcher.start();
        }
        return -1;
    }

    private File createDestFile(String md5, String suffix) {
        return new File(this.getStoreRoot(), this.relativeFilePath(md5, suffix));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.partition);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalBinaryStore other = (LocalBinaryStore)obj;
        return Objects.equals(this.partition, other.partition);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LocalBinaryStore [partition=").append(this.partition).append(", storeRoot=").append(this.storeRoot).append("]");
        return builder.toString();
    }

    private static String slashify(String path, boolean isDirectory) {
        String p = path;
        if (File.separatorChar != '/') {
            p = p.replace(File.separatorChar, '/');
        }
        if (!p.startsWith("/")) {
            p = "/" + p;
        }
        if (!p.endsWith("/") && isDirectory) {
            p = p + "/";
        }
        return p;
    }
}

