/*
 * Decompiled with CFR 0.152.
 */
package gu.sql2java.velocity;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import net.gdface.utils.ClassResourceUtils;
import net.gdface.utils.ConditionChecks;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.util.StringUtils;

public class Sql2javaClasspathResourceLoader
extends ClasspathResourceLoader {
    private List<String> prefix = new ArrayList<String>();

    public void init(ExtendedProperties configuration) {
        Vector vector = configuration.getVector("prefix");
        this.prefix.addAll(Lists.transform((List)vector, (Function)new Function<String, String>(){

            public String apply(String input) {
                String path = StringUtils.normalizePath((String)input);
                ConditionChecks.checkArgument((!Strings.isNullOrEmpty((String)path) ? 1 : 0) != 0, (String)"INVALID resource path prefix [%s]", (Object[])new Object[]{input});
                if (path.equals("/")) {
                    return path;
                }
                return path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
            }
        }));
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Sql2javaClasspathResourceLoader : prefix:" + this.prefix.toString()));
        }
        super.init(configuration);
    }

    public InputStream getResourceStream(String name) throws ResourceNotFoundException {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new ResourceNotFoundException("No template name provided");
        }
        String path = StringUtils.normalizePath((String)name);
        if (Strings.isNullOrEmpty((String)path)) {
            String msg = "No valid template name provided " + name + " contains .. and may be trying to access invalid reference";
            this.log.error((Object)("Sql2javaClasspathResourceLoader : " + msg));
            throw new ResourceNotFoundException(msg);
        }
        if (name.startsWith("/")) {
            return this.toResourceStream(path);
        }
        for (String p : this.prefix) {
            try {
                return this.toResourceStream(p + path);
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
            }
        }
        throw new ResourceNotFoundException("Sql2javaClasspathResourceLoader Error: cannot find resource " + name);
    }

    private InputStream toResourceStream(String path) {
        try {
            List fileList = ClassResourceUtils.getResourceList(((Object)((Object)this)).getClass(), (String)path, (ClassResourceUtils.TypeFilter)ClassResourceUtils.TypeFilter.DEFAULT);
            return new ByteArrayInputStream(Joiner.on((String)"\n").join((Iterable)fileList).getBytes());
        }
        catch (FileNotFoundException e) {
            return super.getResourceStream(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

