/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.l0km.thrift.swift2thrift.generator;

import com.facebook.swift.codec.metadata.DecoratorThriftFieldMetadata;
import com.facebook.swift.generator.swift2thrift.Swift2ThriftGeneratorConfig;
import com.gitee.l0km.thrift.swift2thrift.generator.Swift2ThriftGenerator;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.gdface.utils.MiscellaneousUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class Swift2ThriftMojo
extends AbstractMojo {
    @Parameter(required=true, property="swift2thrift.swiftClassNames")
    private List<String> swiftClassNames;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/thrift.thrift", property="swift2thrift.out")
    private File out = null;
    @Parameter(property="swift2thrift.include")
    private Map<String, String> include = ImmutableMap.of();
    @Parameter(property="swift2thrift.verbose")
    private boolean verbose = false;
    @Parameter(required=true, property="swift2thrift.defaultPackage")
    private String defaultPackage = "";
    @Parameter(property="swift2thrift.namespace")
    private Map<String, String> namespace = ImmutableMap.of();
    @Parameter(property="swift2thrift.allowMultiplePackages")
    private String allowMultiplePackages;
    @Parameter(property="swift2thrift.recursive")
    private boolean recursive = false;
    @Parameter(property="swift2thrift.primitiveOptional")
    private boolean primitiveOptional = true;
    @Parameter
    private boolean objectOptional = false;
    @Parameter(property="swift2thrift.excludeMethods")
    private String excludeMethods = "";
    @Parameter(property="swift2thrift.includeMethods")
    private String includeMethods = "";
    @Parameter(property="swift2thrift.sortByInclude")
    private boolean sortByInclude = false;
    @Parameter(alias="erpc", property="swift2thrift.erpc")
    private boolean generateErpcIDL = false;
    @Parameter(property="swift2thrift.erpc.programName")
    private String programName = "";
    @Parameter(property="swift2thrift.erpc.PortPrefix")
    private String portPrefix;
    @Parameter(property="swift2thrift.sourcePath")
    private String sourcePath;
    @Parameter(property="swift2thrift.classPath")
    private String classPath;
    @Parameter(property="swift2thrift.javadocEnable")
    private boolean javadocEnable;
    @Parameter(property="swift2thrift.erpc.defaultMaxLength")
    private int defaultMaxLength = 256;
    @Parameter(property="swift2thrift.erpc.errmsgMaxLength")
    private int errmsgMaxLength = 256;
    @Parameter(property="swift2thrift.erpc.proxy")
    private boolean erpcProxy = true;
    @Parameter(property="swift2thrift.erpc.excludeFields")
    public Map<String, String> excludeFields;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Swift2thrift plugin generate IDL file(\u751f\u6210Thrift\u63a5\u53e3\u5b9a\u4e49\u6587\u4ef6)");
        this.getLog().info((CharSequence)("swiftClassNames = " + this.swiftClassNames));
        this.getLog().info((CharSequence)("outputFile = " + this.out.getAbsolutePath()));
        this.getLog().info((CharSequence)("defaultPackage = " + this.defaultPackage));
        this.getLog().info((CharSequence)("allowMultiplePackages = " + this.allowMultiplePackages));
        this.getLog().info((CharSequence)("include = " + this.include));
        this.getLog().info((CharSequence)("namespace = " + this.namespace));
        this.getLog().info((CharSequence)("primitiveOptional = " + this.primitiveOptional));
        this.getLog().info((CharSequence)("objectOptional = " + this.objectOptional));
        this.getLog().info((CharSequence)("generateErpcIDL = " + this.generateErpcIDL));
        if (this.generateErpcIDL) {
            this.getLog().info((CharSequence)("\teEPC programName = " + this.programName));
            this.getLog().info((CharSequence)("\teEPC portPrefix = " + this.portPrefix));
        }
        String formated = Joiner.on((String)",\n\t\t").join((Iterable)MiscellaneousUtils.elementsOf((String)this.excludeMethods));
        this.getLog().info((CharSequence)("excludeMethods = " + formated));
        this.getLog().info((CharSequence)("recursive = " + this.recursive));
        this.getLog().info((CharSequence)("verbose = " + this.verbose));
        this.getLog().info((CharSequence)("sourcepath = " + this.sourcePath));
        this.getLog().info((CharSequence)("classpath = " + this.classPath));
        this.getLog().info((CharSequence)("javadocEnable = " + this.javadocEnable));
        this.getLog().info((CharSequence)("defaultMaxLength = " + this.defaultMaxLength));
        this.getLog().info((CharSequence)("erpcProxy = " + this.erpcProxy));
        this.getLog().info((CharSequence)("excludeFields = " + this.excludeFields));
        Swift2ThriftGeneratorConfig.Builder configBuilder = Swift2ThriftGeneratorConfig.builder().outputFile(this.out).includeMap(this.include).verbose(this.verbose).defaultPackage(this.defaultPackage).namespaceMap(this.namespace).allowMultiplePackages(this.allowMultiplePackages).recursive(this.recursive);
        DecoratorThriftFieldMetadata.setPrimitiveOptional((boolean)this.primitiveOptional);
        DecoratorThriftFieldMetadata.setObjectOptional((Boolean)this.objectOptional);
        try {
            new Swift2ThriftGenerator(configBuilder.build()).setExcludeMethods(this.excludeMethods).setIncludeMethods(this.includeMethods).setSortByInclude(this.sortByInclude).setGenerateErpcIDL(this.generateErpcIDL).setProgramName(this.programName).setPortPrefix(this.portPrefix).setSourcepath(this.sourcePath).setClasspath(this.classPath).setJavadocEnable(this.javadocEnable).setDefaultMaxLength(this.defaultMaxLength).setErrmsgMaxLength(this.errmsgMaxLength).setErpcProxy(this.erpcProxy).setExcludeFields(this.excludeFields).parse(this.swiftClassNames);
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }
}

