/*
 * Decompiled with CFR 0.152.
 */
package net.facelib.zyfsdk;

import android.graphics.Bitmap;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import net.facelib.akcore.LicenseManager;
import net.facelib.akcore.ProductInitStatus;
import net.facelib.jni.BaseJniBridge;
import net.facelib.jni.BridgePool;
import net.facelib.jni.SdkRuntime;
import net.facelib.zyfsdk.NativeFaceInfo;
import net.facelib.zyfsdk.ZyfAndroidArmBridge;
import net.facelib.zyfsdk.ZyfFeatureSe;
import net.facelib.zyfsdk.ZyfRuntimeParam;
import net.gdface.image.BaseLazyImage;
import net.gdface.image.ImageErrorException;
import net.gdface.image.LazyImage;
import net.gdface.image.MatType;
import net.gdface.sdk.BaseFaceApiLocal;
import net.gdface.sdk.CodeInfo;
import net.gdface.sdk.ContextLoader;
import net.gdface.sdk.FaceApi;
import net.gdface.sdk.FaceApiGenericDecorator;
import net.gdface.sdk.NotFaceDetectedException;
import net.gdface.sdk.fse.FeatureSe;
import net.gdface.utils.ShareLock;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class FaceApiZyfAndroid
extends BaseFaceApiLocal {
    private static final ThreadLocal<int[]> faceBuffer = new ThreadLocal<int[]>(){

        @Override
        protected int[] initialValue() {
            return new int[1824];
        }
    };
    private static GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
    private static final FaceApiZyfAndroid INSTANCE = new FaceApiZyfAndroid();
    private static final FaceApiGenericDecorator GENERIC_INSTANCE = new FaceApiGenericDecorator((FaceApi)INSTANCE);
    static final Map<ContextLoader.ContextField, Object> CONTEXT;
    private final BridgePool<ZyfAndroidArmBridge> poolWrap = new BridgePool(ZyfAndroidArmBridge.class, poolConfig);
    public final SdkRuntime sdkRuntime = new SdkRuntime(ZyfRuntimeParam.class);

    protected FaceApiZyfAndroid() {
        this.capacity.put("FDDATA_SIZE", "912");
        this.capacity.put("FDMAX_FACE_COUNT", "8");
        this.capacity.put("FEATURE_SIZE", "2056");
        this.capacity.put("SDK_VERSION", "ZYFSDK");
        this.capacity.put("WEAR_MASK", Boolean.toString(true));
    }

    public static FaceApiZyfAndroid getInstance() {
        return INSTANCE;
    }

    public static FaceApiGenericDecorator getGenericInstance() {
        return GENERIC_INSTANCE;
    }

    public static LicenseManager licenseManager() {
        return ZyfAndroidArmBridge.LICENSE_MANAGER;
    }

    protected MatType getNativeMatrixType() {
        return MatType.RGB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double nativeCompareCode(byte[] code1, byte[] code2) {
        ZyfAndroidArmBridge instance = (ZyfAndroidArmBridge)this.poolWrap.applyInstance();
        try {
            double d = instance.compareFeature(code1, code2);
            return d;
        }
        finally {
            this.poolWrap.returnInstance((BaseJniBridge)instance);
        }
    }

    protected void nativeDetectFace(MatType matType, byte[] imgMatrix, int width, int height, List<CodeInfo> faceInfo) {
        this.nativeDetectFace(matType, imgMatrix, width, height, faceInfo, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] nativeGetFaceFeature(MatType matType, byte[] imgMatrix, int width, int height, CodeInfo faceInfo) {
        ZyfAndroidArmBridge instance = (ZyfAndroidArmBridge)this.poolWrap.applyInstance();
        try {
            NativeFaceInfo nativeFaceInfo = instance.toNative((CodeInfo)Preconditions.checkNotNull((Object)faceInfo, (Object)"faceInfo is null"));
            this.sdkRuntime.setInstanceParam((SdkRuntime.RuntimeConsumer)instance, ZyfRuntimeParam.threadNumber.name());
            byte[] byArray = instance.getFeature(matType, imgMatrix, width, height, nativeFaceInfo.nativeData);
            return byArray;
        }
        finally {
            this.poolWrap.returnInstance((BaseJniBridge)instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nativeDetectFace(MatType matType, byte[] imgMatrix, int width, int height, List<CodeInfo> faceInfo, int detectMod) {
        int[] buffer = faceBuffer.get();
        ZyfAndroidArmBridge instance = (ZyfAndroidArmBridge)this.poolWrap.applyInstance();
        try {
            this.sdkRuntime.setInstanceParam((SdkRuntime.RuntimeConsumer)instance, ZyfRuntimeParam.threadNumber.name());
            this.sdkRuntime.setInstanceParam((SdkRuntime.RuntimeConsumer)instance, ZyfRuntimeParam.minFaceSize.name());
            int res = instance.detect(matType, imgMatrix, width, height, detectMod, buffer);
            for (int i = 0; i < res; ++i) {
                NativeFaceInfo nativeFaceInfo = instance.makeNativeFaceInfo(buffer, i * 228);
                nativeFaceInfo.setAngle(instance.getAngle(matType, imgMatrix, width, height, buffer, i * 228));
                faceInfo.add(nativeFaceInfo);
            }
        }
        finally {
            this.poolWrap.returnInstance((BaseJniBridge)instance);
        }
    }

    private NativeFaceInfo getMaxFaceInFacePos(ZyfAndroidArmBridge instance, MatType matType, byte[] imgMatrix, int width, int height, int[] pFacePos, int faceNum) {
        if (faceNum <= 0) {
            return null;
        }
        int maxOffset = 0;
        int maxArea = 0;
        for (int i = 0; i < faceNum; ++i) {
            int offset = i * 228;
            int area = (pFacePos[offset + 3] - pFacePos[offset + 2]) * (pFacePos[offset + 1] - pFacePos[offset + 0]);
            if (maxArea >= area) continue;
            maxArea = area;
            maxOffset = offset;
        }
        NativeFaceInfo nativeFaceInfo = instance.makeNativeFaceInfo(pFacePos, maxOffset);
        nativeFaceInfo.setAngle(instance.getAngle(matType, imgMatrix, width, height, pFacePos, maxOffset));
        return nativeFaceInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NativeFaceInfo nativeDetectMaxFace(MatType matType, byte[] imgMatrix, int width, int height, int portrait) {
        ZyfAndroidArmBridge instance = (ZyfAndroidArmBridge)this.poolWrap.applyInstance();
        try {
            this.sdkRuntime.setInstanceParam((SdkRuntime.RuntimeConsumer)instance, ZyfRuntimeParam.threadNumber.name());
            this.sdkRuntime.setInstanceParam((SdkRuntime.RuntimeConsumer)instance, ZyfRuntimeParam.minFaceSize.name());
            int[] pFacePos = faceBuffer.get();
            int faceNum = instance.detect(matType, imgMatrix, width, height, portrait, pFacePos);
            NativeFaceInfo nativeFaceInfo = this.getMaxFaceInFacePos(instance, matType, imgMatrix, width, height, pFacePos, faceNum);
            return nativeFaceInfo;
        }
        finally {
            this.poolWrap.returnInstance((BaseJniBridge)instance);
        }
    }

    public NativeFaceInfo detectMaxFace(Bitmap bitmap, int portrait) {
        try {
            BaseLazyImage lazyImg = BaseLazyImage.getLazyImageFactory().create((Object)bitmap);
            byte[] matrix = lazyImg.getMatrixData(this.getNativeMatrixType());
            return this.nativeDetectMaxFace(this.getNativeMatrixType(), matrix, bitmap.getWidth(), bitmap.getHeight(), portrait);
        }
        catch (ImageErrorException e) {
            throw new RuntimeException(e);
        }
    }

    public List<CodeInfo> detectFace(Bitmap bitmap, int portrait) {
        try {
            BaseLazyImage lazyImg = BaseLazyImage.getLazyImageFactory().create((Object)bitmap);
            byte[] matrix = lazyImg.getMatrixData(this.getNativeMatrixType());
            ArrayList<CodeInfo> faceInfo = new ArrayList<CodeInfo>();
            this.nativeDetectFace(this.getNativeMatrixType(), matrix, bitmap.getWidth(), bitmap.getHeight(), faceInfo, portrait);
            return faceInfo;
        }
        catch (ImageErrorException e) {
            throw new RuntimeException(e);
        }
    }

    public List<CodeInfo> getCodeInfo(Bitmap bitmap, int faceNum, List<CodeInfo> facePos) throws NotFaceDetectedException {
        return this.getCodeInfo((BaseLazyImage)LazyImage.create((Bitmap)bitmap), faceNum, facePos);
    }

    public CodeInfo getCodeInfo(Bitmap bitmap, CodeInfo facePos) {
        return this.getCodeInfo((BaseLazyImage)LazyImage.create((Bitmap)bitmap), facePos);
    }

    public CodeInfo[] detectAndGetCodeInfo(Bitmap bitmap, int faceNum) throws NotFaceDetectedException {
        try {
            return this.detectAndGetCodeInfo((BaseLazyImage)LazyImage.create((Bitmap)bitmap).open(), faceNum);
        }
        catch (ImageErrorException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean nativeWearMask(MatType matType, byte[] imgMatrix, int width, int height, CodeInfo faceInfo) {
        ZyfAndroidArmBridge instance = (ZyfAndroidArmBridge)this.poolWrap.applyInstance();
        try {
            NativeFaceInfo nativeFaceInfo = instance.toNative(faceInfo);
            this.sdkRuntime.setInstanceParam((SdkRuntime.RuntimeConsumer)instance, ZyfRuntimeParam.threadNumber.name());
            Boolean bl = instance.wearMask(matType, imgMatrix, width, height, nativeFaceInfo.nativeData);
            return bl;
        }
        finally {
            this.poolWrap.returnInstance((BaseJniBridge)instance);
        }
    }

    public void bindNativeInstanceForCurentThread() {
        this.poolWrap.bindInstanceForCurentThread();
    }

    public void unbindNativeInstanceForCurentThread() {
        this.poolWrap.unbindInstanceForCurentThread();
    }

    public void bindNativeDetectInstanceForCurentThread() {
        this.bindNativeInstanceForCurentThread();
    }

    public void unbindNativeDetectInstanceForCurentThread() {
        this.unbindNativeInstanceForCurentThread();
    }

    public void bindNativeFeatureInstanceForCurentThread() {
        this.bindNativeInstanceForCurentThread();
    }

    public void unbindNativeFeatureInstanceForCurentThread() {
        this.unbindNativeInstanceForCurentThread();
    }

    public ProductInitStatus testInit(AtomicLong initMills) {
        return BaseJniBridge.testInit((AtomicLong)initMills, ZyfAndroidArmBridge.class);
    }

    public GenericObjectPool<ZyfAndroidArmBridge> getPool() {
        return this.poolWrap.getPool();
    }

    public FeatureSe getFeatureSe() {
        return ZyfFeatureSe.INSTANCE;
    }

    public static GenericObjectPoolConfig getPoolConfig() {
        return poolConfig;
    }

    public static void setPoolConfig(GenericObjectPoolConfig poolConfig) {
        if (null != poolConfig) {
            FaceApiZyfAndroid.poolConfig = poolConfig;
        }
    }

    static {
        try {
            Class.forName(ZyfAndroidArmBridge.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionInInitializerError(e);
        }
        int concurrency = ZyfAndroidArmBridge.CONFIG.getConcurrency();
        if (concurrency > 0) {
            concurrentLock = new ShareLock(concurrency);
        }
        HashMap<ContextLoader.ContextField, FaceApiZyfAndroid> m = new HashMap<ContextLoader.ContextField, FaceApiZyfAndroid>();
        m.put(ContextLoader.ContextField.INSTANCE, FaceApiZyfAndroid.getInstance());
        m.put(ContextLoader.ContextField.LICENCE_MANAGER, (FaceApiZyfAndroid)FaceApiZyfAndroid.licenseManager());
        CONTEXT = Collections.unmodifiableMap(m);
    }
}

