/*
 * Decompiled with CFR 0.152.
 */
package net.facelib.zyfsdk;

import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.facelib.akcore.NativeProductStatus;
import net.facelib.jni.SdkInitException;
import net.facelib.zyfsdk.SdkStatus;
import net.facelib.zyfsdk.jna.Zyfsdk_refineLibrary;

class KeyCodeCodec {
    private static final String DES_PATTERN = "@(.+)@(.+)@(.+)@(.+)@(.+)@(.+)@(.+)@\\s*";
    static final KeyCodeCodec CODEC_SINGLETON = new KeyCodeCodec();

    private KeyCodeCodec() {
    }

    String decodeKey(byte[] input) throws SdkInitException {
        String decrypt = Zyfsdk_refineLibrary.INSTANCE.rf_decode_key(input, input.length);
        if (Strings.isNullOrEmpty((String)decrypt)) {
            throw new SdkInitException(Zyfsdk_refineLibrary.INSTANCE.rf_error_message(), (NativeProductStatus)SdkStatus.SN_DECODE_ERROR);
        }
        Pattern pattern = Pattern.compile(DES_PATTERN);
        Matcher macher = pattern.matcher(decrypt);
        if (!macher.matches()) {
            throw new SdkInitException(String.format("decoded %s", decrypt), (NativeProductStatus)SdkStatus.MISMATCH_SN_PATTERN);
        }
        return macher.group(6);
    }
}

