/*
 * Decompiled with CFR 0.152.
 */
package net.facelib.zyfsdk;

import android.util.Log;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;

class MacUtil {
    private static final String NETWORK_WLAN = "wlan0";
    private static final String NETWORK_ETH = "eth0";

    MacUtil() {
    }

    static String getMAC() {
        String mac = MacUtil.getMacAddress(NETWORK_WLAN);
        if (null == mac) {
            mac = MacUtil.getMacAddress(NETWORK_ETH);
        }
        if (null == mac) {
            mac = "02:00:00:00:00:00";
        }
        return mac;
    }

    static byte[] getMACByte() {
        byte[] mac = MacUtil.getMacAddressByte(NETWORK_WLAN);
        if (null == mac) {
            mac = MacUtil.getMacAddressByte(NETWORK_ETH);
        }
        if (null == mac) {
            mac = new byte[6];
        }
        return mac;
    }

    private static String getMacAddress(String netWork) {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface ntwInterface : interfaces) {
                if (!ntwInterface.getName().equalsIgnoreCase(netWork)) continue;
                byte[] byteMac = ntwInterface.getHardwareAddress();
                if (byteMac == null) {
                    // empty if block
                }
                StringBuilder strBuilder = new StringBuilder();
                for (int i = 0; i < byteMac.length; ++i) {
                    strBuilder.append(String.format("%02X:", byteMac[i]));
                }
                if (strBuilder.length() > 0) {
                    strBuilder.deleteCharAt(strBuilder.length() - 1);
                }
                return strBuilder.toString();
            }
        }
        catch (Exception e) {
            Log.d((String)"MacUtil", (String)e.getMessage());
        }
        return null;
    }

    private static byte[] getMacAddressByte(String netWork) {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface ntwInterface : interfaces) {
                byte[] byteMac;
                if (!ntwInterface.getName().equalsIgnoreCase(netWork) || null == (byteMac = ntwInterface.getHardwareAddress())) continue;
                return byteMac;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

