/*
 * Decompiled with CFR 0.152.
 */
package net.facelib.zyfsdk;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.zyface.facemodel.ZYFaceEngine;
import gu.jimgutil.MatrixUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ServiceLoader;
import net.facelib.akcore.AuthParameter;
import net.facelib.akcore.LicenseManager;
import net.facelib.akcore.LicenseUtils;
import net.facelib.akcore.NativeProductStatus;
import net.facelib.akcore.ProductInitStatus;
import net.facelib.jni.BaseJniBridge;
import net.facelib.jni.BridgeLog;
import net.facelib.jni.SdkInitException;
import net.facelib.jni.SdkRuntimeException;
import net.facelib.sdk.ImageSupport;
import net.facelib.zyfsdk.DefaultZyfAndroidConfig;
import net.facelib.zyfsdk.DefaultZyfLicenseManager;
import net.facelib.zyfsdk.NativeFaceInfo;
import net.facelib.zyfsdk.SdkRuntime;
import net.facelib.zyfsdk.SdkStatus;
import net.facelib.zyfsdk.ZyfAndroidConfigProvider;
import net.facelib.zyfsdk.ZyfRuntimeParam;
import net.facelib.zyfsdk.jna.Zyfsdk_refineLibrary;
import net.gdface.image.MatType;
import net.gdface.sdk.CodeInfo;
import net.gdface.sdk.EyeInfo;
import net.gdface.sdk.FAngle;
import net.gdface.sdk.FRect;
import net.gdface.utils.Assert;
import net.gdface.utils.BufferUtils;
import net.gdface.utils.ConditionChecks;
import net.gdface.utils.SimpleLog;
import org.apache.commons.codec.binary.Base64;

public class ZyfAndroidArmBridge
extends BaseJniBridge {
    public static final ZyfAndroidConfigProvider CONFIG = ZyfAndroidArmBridge.getConfigProvider();
    public static final String SDK_VERSION = "ZYFSDK";
    static final String ZYFSDK_PRODUCT_ID = "ZYFSDK_android";
    public static final LicenseManager LICENSE_MANAGER = LicenseUtils.getLicenseManager((String)"ZYFSDK_android", (LicenseManager)new DefaultZyfLicenseManager());
    private final long[] pHandle = new long[]{0L};
    private volatile int featureSize = 0;
    private volatile SdkStatus status = SdkStatus.SDK_UNINITIALIZED;
    private static volatile Boolean licenseFileLoaded = null;
    private static volatile int initMode = 0;

    private static ZyfAndroidConfigProvider getConfigProvider() {
        ServiceLoader<ZyfAndroidConfigProvider> providers = ServiceLoader.load(ZyfAndroidConfigProvider.class);
        Iterator<ZyfAndroidConfigProvider> itor = providers.iterator();
        if (!itor.hasNext()) {
            return new DefaultZyfAndroidConfig();
        }
        return itor.next();
    }

    public SdkStatus getStatus() {
        return this.status;
    }

    protected void sdkInit(String licenseFile, String licenseKey, String licenseCode) throws SdkInitException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doSdkInit(String licenseCode) throws SdkInitException {
        if (SdkStatus.SDK_INIT_OK == this.status) {
            return;
        }
        try {
            byte[] bpKeyCode = Base64.decodeBase64((byte[])licenseCode.getBytes(Charsets.UTF_8));
            int flag = ZYFaceEngine.ZYInitFace(this.pHandle, bpKeyCode, SdkRuntime.getContext());
            BridgeLog.BRIDEG_LOGGER.log("ZYInitFace pHandle: [{}]", new Object[]{this.pHandle[0]});
            SdkStatus sdkStatus = this.status = flag == 0 ? SdkStatus.SDK_INIT_OK : SdkStatus.jniCode(flag);
            if (this.status != SdkStatus.SDK_INIT_OK) {
                BridgeLog.BRIDEG_LOGGER.log("zyfsdk module: {}", new Object[]{this});
                throw new SdkInitException((NativeProductStatus)this.status);
            }
            if (this.status == SdkStatus.SDK_INIT_OK) return;
        }
        catch (Throwable throwable) {
            if (this.status == SdkStatus.SDK_INIT_OK) throw throwable;
            BridgeLog.BRIDEG_LOGGER.log("ZYReleaseFace caused by init fail {}", new Object[]{this});
            ZYFaceEngine.ZYReleaseFace(this.pHandle);
            this.pHandle[0] = 0L;
            throw throwable;
        }
        BridgeLog.BRIDEG_LOGGER.log("ZYReleaseFace caused by init fail {}", new Object[]{this});
        ZYFaceEngine.ZYReleaseFace(this.pHandle);
        this.pHandle[0] = 0L;
    }

    protected LicenseManager licenseManager() {
        return LICENSE_MANAGER;
    }

    private static void checkError(int code) throws SdkInitException {
        if (code < 0) {
            throw new SdkInitException(Zyfsdk_refineLibrary.INSTANCE.rf_error_message(), (NativeProductStatus)SdkStatus.LICENSE_FILE_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void lazyLoadLicenseFile() throws SdkInitException {
        if (Boolean.TRUE.equals(licenseFileLoaded)) return;
        Class<ZyfAndroidArmBridge> clazz = ZyfAndroidArmBridge.class;
        synchronized (ZyfAndroidArmBridge.class) {
            if (Boolean.TRUE.equals(licenseFileLoaded)) return;
            try {
                String licenseFile = LICENSE_MANAGER.provider().stringOf(AuthParameter.LICENSE_FILE);
                ConditionChecks.checkTrue((!Strings.isNullOrEmpty((String)licenseFile) ? 1 : 0) != 0, SdkInitException.class, (Object)"INVALID licenseFile");
                ConditionChecks.checkTrue((boolean)new File(licenseFile).isFile(), SdkInitException.class, (String)"NOT FOUND licenseFile %s", (Object)licenseFile);
                BridgeLog.BRIDEG_LOGGER.log("rf_load_license_file licenseFile: [{}]", new Object[]{licenseFile});
                int code = Zyfsdk_refineLibrary.INSTANCE.rf_load_license_file(licenseFile);
                ZyfAndroidArmBridge.checkError(code);
                licenseFileLoaded = Boolean.TRUE;
            }
            catch (RuntimeException e) {
                BridgeLog.BRIDEG_LOGGER.log("{}:{}", new Object[]{e.getClass().getName(), e.getMessage()});
                BridgeLog.BRIDEG_LOGGER.logTrace(true, (Throwable)e);
                throw e;
            }
            return;
        }
    }

    public static void reset() {
        licenseFileLoaded = null;
    }

    private String getLicenseKey() throws SdkInitException {
        switch (initMode) {
            case 1: {
                ZyfAndroidArmBridge.lazyLoadLicenseFile();
                String key = Zyfsdk_refineLibrary.INSTANCE.rf_get_license_key();
                BridgeLog.BRIDEG_LOGGER.log("rf_get_license_key key: [{}]", new Object[]{key});
                ConditionChecks.checkTrue((null != key ? 1 : 0) != 0, SdkInitException.class, (Object)((Object)SdkStatus.INVALID_LICENSE_KEY), (String)Zyfsdk_refineLibrary.INSTANCE.rf_error_message(), (Object[])new Object[0]);
                return key;
            }
            case 2: {
                String licenseKey = LICENSE_MANAGER.provider().stringOf(AuthParameter.LICENSE_KEY_OLD);
                String licenseCode = LICENSE_MANAGER.provider().stringOf(AuthParameter.LICENSE_CODE_OLD);
                ConditionChecks.checkTrue((null != licenseKey && licenseCode != null ? 1 : 0) != 0, SdkInitException.class, (Object)"LICENSE_KEY_OLD,LICENSE_CODE_OLD not defined ");
                return licenseCode;
            }
        }
        StringBuilder builder = new StringBuilder();
        String licenseFile = LICENSE_MANAGER.provider().stringOf(AuthParameter.LICENSE_FILE);
        if (licenseFile != null) {
            try {
                ZyfAndroidArmBridge.lazyLoadLicenseFile();
                String key = Zyfsdk_refineLibrary.INSTANCE.rf_get_license_key();
                BridgeLog.BRIDEG_LOGGER.log("rf_get_license_key key: [{}]", new Object[]{key});
                ConditionChecks.checkTrue((null != key ? 1 : 0) != 0, SdkInitException.class, (Object)((Object)SdkStatus.INVALID_LICENSE_KEY), (String)Zyfsdk_refineLibrary.INSTANCE.rf_error_message(), (Object[])new Object[0]);
                initMode = 1;
                return key;
            }
            catch (SdkInitException e) {
                builder.append(SimpleLog.logString((String)"[AM_AK] fail to get license key cause by {}({}) ", (Object[])new Object[]{e.status.getEnumName(), e.status.getMessage()}));
            }
        }
        String licenseKey = LICENSE_MANAGER.provider().stringOf(AuthParameter.LICENSE_KEY_OLD);
        String licenseCode = LICENSE_MANAGER.provider().stringOf(AuthParameter.LICENSE_CODE_OLD);
        if (null != licenseKey && licenseCode != null) {
            initMode = 2;
            return licenseCode;
        }
        builder.append(SimpleLog.logString((String)"[AM_OL] fail to get license key  cause by LICENSE_KEY_OLD OR LICENSE_CODE_OLD not defined ", (Object[])new Object[0]));
        throw new SdkInitException(builder.toString(), (NativeProductStatus)ProductInitStatus.PRODUCT_INIT_FAIL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws SdkInitException {
        Object object = this.mutex;
        synchronized (object) {
            String key = this.getLicenseKey();
            this.doSdkInit(key);
        }
    }

    protected void sdkUninit() {
        if (SdkStatus.SDK_INIT_OK == this.status) {
            this.status = SdkStatus.SDK_UNINITIALIZED;
            BridgeLog.BRIDEG_LOGGER.log("ZYReleaseFace {}", new Object[]{this});
            ZYFaceEngine.ZYReleaseFace(this.pHandle);
            this.pHandle[0] = 0L;
        }
    }

    public double compareFeature(byte[] feature1, byte[] feature2) {
        float[] frvalue = new float[1];
        int ret = ZYFaceEngine.ZYCompareFaceFeatureMix(this.pHandle, feature1, feature2, frvalue);
        if (ret != 0) {
            SdkStatus code = SdkStatus.jniCode(ret);
            BridgeLog.BRIDEG_LOGGER.log("ZYCompareFaceFeatureMix code={} {}", new Object[]{code, this});
            throw new SdkRuntimeException((NativeProductStatus)code);
        }
        return frvalue[0];
    }

    public int detect(MatType matType, byte[] matData, int width, int height, int portrait, int[] pFacePos) {
        if (MatType.NV21.equals((Object)matType)) {
            return this.nv21Detect(matData, width, height, pFacePos);
        }
        ZYFaceEngine.ZYSetPortrait(this.pHandle, portrait);
        byte[] gray = MatrixUtils.RGB2GRAY((byte[])matData, (int)width, (int)height, (int)(width * 3));
        byte[] rgb = ImageSupport.toRGB((MatType)matType, (byte[])matData, (int)width, (int)height);
        int[] pnDetectFaceNum = new int[]{pFacePos.length / 228};
        int ret = ZYFaceEngine.ZYDetectMultiFaceByRGB(this.pHandle, gray, rgb, width, height, pFacePos, pnDetectFaceNum);
        if (ret < 0) {
            SdkStatus code = SdkStatus.jniCode(ret);
            BridgeLog.BRIDEG_LOGGER.log("ZYDetectMultiFaceByRGB code={} {}", new Object[]{code, this});
            throw new SdkRuntimeException((NativeProductStatus)code);
        }
        return ret == 0 ? pnDetectFaceNum[0] : 0;
    }

    public byte[] getFeature(MatType matType, byte[] matrix, int width, int height, int[] pFacePos) {
        int ret;
        switch (matType) {
            case RGB: {
                break;
            }
            case NV21: {
                byte[] rgb = new byte[width * height * 3];
                ret = ZYFaceEngine.ZYNV21TORGB(width, height, matrix, rgb);
                if (ret != 0) {
                    SdkStatus code = SdkStatus.jniCode(ret);
                    BridgeLog.BRIDEG_LOGGER.log("ZYNV21TORGB code={} {}", new Object[]{code, this});
                    throw new SdkRuntimeException((NativeProductStatus)code);
                }
                matrix = rgb;
                break;
            }
            default: {
                byte[] rgb = ImageSupport.toRGB((MatType)matType, (byte[])matrix, (int)width, (int)height);
                matrix = rgb;
            }
        }
        byte[] buffer = new byte[this.getFeatureSize()];
        ret = ZYFaceEngine.ZYGetFaceFeatureEx(this.pHandle, matrix, width, height, pFacePos, buffer);
        if (ret != 0) {
            SdkStatus code = SdkStatus.jniCode(ret);
            BridgeLog.BRIDEG_LOGGER.log("ZYGetFaceFeatureEx code={} {}", new Object[]{code, this});
            throw new SdkRuntimeException((NativeProductStatus)code);
        }
        return buffer;
    }

    public boolean wearMask(MatType matType, byte[] matrix, int width, int height, int[] pFacePos) {
        switch (matType) {
            case RGB: {
                break;
            }
            case NV21: {
                byte[] rgb = new byte[width * height * 3];
                int ret = ZYFaceEngine.ZYNV21TORGB(width, height, matrix, rgb);
                if (ret != 0) {
                    SdkStatus code = SdkStatus.jniCode(ret);
                    BridgeLog.BRIDEG_LOGGER.log("ZYNV21TORGB code={} {}", new Object[]{code, this});
                    throw new SdkRuntimeException((NativeProductStatus)code);
                }
                matrix = rgb;
                ZYFaceEngine.ZYSetPortrait(this.pHandle, 0);
                break;
            }
            default: {
                byte[] rgb = ImageSupport.toRGB((MatType)matType, (byte[])matrix, (int)width, (int)height);
                matrix = rgb;
            }
        }
        int[] pnRst = new int[1];
        float[] pfScore = new float[2];
        int ret = ZYFaceEngine.ZYJudgeMask(this.pHandle, matrix, width, height, pFacePos, pnRst, pfScore);
        if (ret != 0) {
            SdkStatus code = SdkStatus.jniCode(ret);
            BridgeLog.BRIDEG_LOGGER.log("ZYJudgeMask code={} {}", new Object[]{code, this});
            throw new SdkRuntimeException((NativeProductStatus)code);
        }
        return pnRst[0] == 1;
    }

    void judgeFaceQuality(MatType matType, byte[] matrix, int width, int height, int[] pFacePos, int offset, int[] pnFaceScore, float[] pfFacePose) {
        byte[] gray = ImageSupport.toGRAY((MatType)matType, (byte[])matrix, (int)width, (int)height);
        int ret = ZYFaceEngine.ZYJudgeFaceQuality(this.pHandle, gray, width, height, Arrays.copyOfRange(pFacePos, offset, offset + 228), pnFaceScore, pfFacePose);
        if (ret != 0) {
            SdkStatus code = SdkStatus.jniCode(ret);
            BridgeLog.BRIDEG_LOGGER.log("ZYJudgeFaceQuality code={} {}", new Object[]{code, this});
            throw new SdkRuntimeException((NativeProductStatus)code);
        }
    }

    public int nv21Detect(byte[] nv21, int width, int height, int[] pFacePos) {
        ZYFaceEngine.ZYSetPortrait(this.pHandle, 0);
        int[] pnDetectFaceNum = new int[]{pFacePos.length / 228};
        int ret = ZYFaceEngine.ZYDetectMultiFaceAndEyeEx(this.pHandle, nv21, width, height, pFacePos, pnDetectFaceNum);
        return ret == 0 ? pnDetectFaceNum[0] : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getFeatureSize() {
        if (this.featureSize == 0) {
            ZyfAndroidArmBridge zyfAndroidArmBridge = this;
            synchronized (zyfAndroidArmBridge) {
                if (this.featureSize == 0) {
                    int[] out = new int[1];
                    int ret = ZYFaceEngine.ZYGetFeatureSize(this.pHandle, out);
                    if (ret != 0) {
                        throw new SdkRuntimeException((NativeProductStatus)SdkStatus.jniCode(ret));
                    }
                    this.featureSize = out[0];
                }
            }
        }
        return this.featureSize;
    }

    int[] getEyes(int[] pFacePos) {
        int[] pEyePos = new int[4];
        int ret = ZYFaceEngine.ZYGetEyes(this.pHandle, pFacePos, pEyePos);
        if (ret != 0) {
            throw new SdkRuntimeException((NativeProductStatus)SdkStatus.jniCode(ret));
        }
        return pEyePos;
    }

    FAngle getAngle(MatType matType, byte[] matrix, int width, int height, int[] pFacePos, int offset) {
        int[] pnFaceScore = new int[2];
        float[] pfFacePose = new float[4];
        this.judgeFaceQuality(matType, matrix, width, height, pFacePos, offset, pnFaceScore, pfFacePose);
        return new FAngle((int)pfFacePose[2], (int)pfFacePose[0], (int)pfFacePose[1], 0.0f);
    }

    private void initNativeFaceInfo(NativeFaceInfo nativeFaceInfo, int[] nativeData, int start) {
        Assert.isTrue((start >= 0 ? 1 : 0) != 0, (String)"start>=0", (String)"invalid start");
        Assert.isTrue((nativeData != null && nativeData.length - start >= 228 ? 1 : 0) != 0, (String)"nativeData!=null && nativeData.length-start>=CaffeMobile.FDDATA_LEN", (String)"invalid nativeData");
        nativeFaceInfo.nativeData = new int[228];
        System.arraycopy(nativeData, start, nativeFaceInfo.nativeData, 0, nativeFaceInfo.nativeData.length);
        FRect pos = nativeFaceInfo.getPos();
        if (pos == null) {
            pos = new FRect();
        }
        pos.setLeft(nativeFaceInfo.nativeData[NativeFaceInfo.FieldIndex.FRECT_LEFT.ordinal()]);
        pos.setTop(nativeFaceInfo.nativeData[NativeFaceInfo.FieldIndex.FRECT_TOP.ordinal()]);
        pos.setWidth(nativeFaceInfo.nativeData[NativeFaceInfo.FieldIndex.FRECT_RIGHT.ordinal()] - pos.getLeft());
        pos.setHeight(nativeFaceInfo.nativeData[NativeFaceInfo.FieldIndex.FRECT_BOTTOM.ordinal()] - pos.getTop());
        nativeFaceInfo.setPos(pos);
        EyeInfo ei = nativeFaceInfo.getEi();
        if (ei == null) {
            ei = new EyeInfo();
        }
        int[] pEyePos = this.getEyes(nativeFaceInfo.nativeData);
        ei.setLeftx(pEyePos[0]);
        ei.setLefty(pEyePos[1]);
        ei.setRightx(pEyePos[2]);
        ei.setRighty(pEyePos[3]);
        nativeFaceInfo.setEi(ei);
        nativeFaceInfo.setFacialData(BufferUtils.asByteArray((int[])nativeFaceInfo.nativeData));
    }

    NativeFaceInfo makeNativeFaceInfo(int[] nativeData, int start) {
        NativeFaceInfo nativeFaceInfo = new NativeFaceInfo();
        this.initNativeFaceInfo(nativeFaceInfo, nativeData, start);
        return nativeFaceInfo;
    }

    NativeFaceInfo toNative(CodeInfo code) {
        if (code == null) {
            return null;
        }
        if (code instanceof NativeFaceInfo) {
            return (NativeFaceInfo)code;
        }
        NativeFaceInfo nativeFaceInfo = new NativeFaceInfo();
        byte[] facialData = code.getFacialData();
        Assert.notNull((Object)facialData, (String)"facialData");
        this.makeNativeFaceInfo(BufferUtils.asIntArray((byte[])facialData), 0);
        nativeFaceInfo.setAngle(code.getAngle());
        return (NativeFaceInfo)nativeFaceInfo.relocate();
    }

    public ZyfAndroidArmBridge setRuntimeParam(String name, Object value) throws SdkRuntimeException {
        ZyfRuntimeParam r = ZyfRuntimeParam.valueOf(name);
        switch (r) {
            case threadNumber: {
                int ret;
                int threadNumber;
                int n = threadNumber = value != null ? (Integer)value : 1;
                if (threadNumber <= 0 || (ret = ZYFaceEngine.ZYSetThreadNum(this.pHandle, threadNumber)) == 0) break;
                SdkStatus code = SdkStatus.jniCode(ret);
                BridgeLog.BRIDEG_LOGGER.log("ZYSetThreadNum code={} {}", new Object[]{code, this});
                throw new SdkRuntimeException((NativeProductStatus)code);
            }
            case minFaceSize: {
                int ret;
                int minFaceSize;
                int n = minFaceSize = value != null ? (Integer)value : 60;
                if (minFaceSize < 60 || minFaceSize > 300 || (ret = ZYFaceEngine.ZYSetMinFace(this.pHandle, minFaceSize)) == 0) break;
                SdkStatus code = SdkStatus.jniCode(ret);
                BridgeLog.BRIDEG_LOGGER.log("ZYSetMinFace code={} {}", new Object[]{code, this});
                throw new SdkRuntimeException((NativeProductStatus)code);
            }
            case portrait: {
                int iPortrait = value != null ? (Integer)value : 0;
                int ret = ZYFaceEngine.ZYSetPortrait(this.pHandle, iPortrait);
                if (ret == 0) break;
                SdkStatus code = SdkStatus.jniCode(ret);
                BridgeLog.BRIDEG_LOGGER.log("ZYSetPortrait code={} {}", new Object[]{code, this});
                throw new SdkRuntimeException((NativeProductStatus)code);
            }
            default: {
                throw new IllegalArgumentException(SimpleLog.logString((String)"INVALID parameter name: {}", (Object[])new Object[]{name}));
            }
        }
        return this;
    }

    static String getDeviceNum(byte[] ro_serialno, byte[] mac) {
        byte[] v32 = new byte[257];
        System.arraycopy(ro_serialno, 0, v32, 0, ro_serialno.length - 1);
        System.arraycopy(mac, 0, v32, ro_serialno.length - 1, mac.length);
        int v9 = ro_serialno.length - 1 + mac.length;
        if (v9 == 0) {
            return "";
        }
        int v10 = v9 >> 1;
        int v11 = 0;
        int v12 = 0;
        int v16 = 0;
        int v17 = 0;
        if (v9 >> 1 >= 1) {
            v12 = 0;
            int v13 = v9 >> 1;
            int v14 = 0;
            do {
                byte v15 = v32[v14++];
                v16 = v15 + 16 * v12;
                v17 = v16 | 0xFFFFFFF;
                if ((v16 & 0xF0000000) != 0) {
                    v16 ^= (v16 & 0xF0000000) >>> 24;
                }
                v12 = v16 & (v17 ^ 0xF0000000);
            } while (--v13 > 0);
        }
        int v18 = v9 - v10;
        int v21 = 0;
        int v22 = 0;
        if (v18 >= 1) {
            int v19 = v10;
            v11 = 0;
            do {
                byte v20 = v32[v19++];
                v21 = v20 + 16 * v11;
                v22 = v21 | 0xFFFFFFF;
                if ((v21 & 0xF0000000) != 0) {
                    v21 ^= (v21 & 0xF0000000) >>> 24;
                }
                v11 = v21 & (v22 ^ 0xF0000000);
            } while (--v18 > 0);
        }
        return String.format("%08X%08X", v12, v11);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ZyfAndroidArmBridge [pHandle=");
        builder.append(Arrays.toString(this.pHandle));
        builder.append(", status=");
        builder.append((Object)this.status);
        builder.append("]");
        return builder.toString();
    }

    static {
        BridgeLog.BRIDEG_LOGGER.log("ZyfAndroid Config INSTANCE:{}", new Object[]{DefaultZyfAndroidConfig.toString(CONFIG)});
    }
}

