/*
 * Decompiled with CFR 0.152.
 */
package net.facelib.zyfsdk;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.zyface.facemodel.ZYFaceEngine;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import net.facelib.akcore.NativeProductStatus;
import net.facelib.jni.SdkRuntimeException;
import net.facelib.zyfsdk.SdkStatus;
import net.gdface.sdk.fse.BaseFeatureSeImpl;
import net.gdface.sdk.fse.CodeBean;
import net.gdface.utils.BinaryUtils;
import net.gdface.utils.SimpleLog;

public class ZyfFeatureSe
extends BaseFeatureSeImpl {
    private static final int FEA_OFFSET = 23;
    private static int addFeatureMode = 0;
    private static volatile boolean dbinitialized = false;
    private static int maxId = 0;
    private static BiMap<ByteBuffer, Integer> idmap = HashBiMap.create();
    private static Map<ByteBuffer, CodeBean> featureMap = new Hashtable<ByteBuffer, CodeBean>();
    private static final ReentrantLock dblock = new ReentrantLock();
    public static final ZyfFeatureSe INSTANCE = new ZyfFeatureSe();

    private ZyfFeatureSe() {
    }

    private ZyfFeatureSe checkInitialized() {
        if (!dbinitialized) {
            throw new IllegalStateException("UNINITIALIZED feature SE");
        }
        return this;
    }

    protected static CodeBean getFeature(int id) {
        int[] pnSize = new int[1];
        int ret = ZYFaceEngine.ZYGetLibIDTemplet(id, 0, null, pnSize);
        byte[] pbFeaturesData = new byte[pnSize[0]];
        ret = ZYFaceEngine.ZYGetLibIDTemplet(id, 0, pbFeaturesData, pnSize);
        SdkStatus s = SdkStatus.jniCode(ret);
        switch (s) {
            case ZY_OK: {
                ByteBuffer idBuf = (ByteBuffer)idmap.inverse().get((Object)id);
                CodeBean codeBean = featureMap.get(idBuf);
                byte[] feature = Arrays.copyOfRange(pbFeaturesData, 23, 2079);
                return new CodeBean(codeBean.id, feature, codeBean.imgMD5, null);
            }
            case ZY_E_EMPTY_TPLTLIB: 
            case ZY_E_ID_NOT_FOUND: 
            case ZY_E_TPLT_NOT_FOUND: {
                return null;
            }
        }
        throw new SdkRuntimeException((NativeProductStatus)s);
    }

    public CodeBean[] searchCode(byte[] feature, double sim, int rows) {
        this.checkInitialized();
        Preconditions.checkArgument((feature != null && feature.length == 2056 ? 1 : 0) != 0, (Object)"INVALID feature data");
        dblock.lock();
        try {
            int[] pnRstID = new int[1];
            float[] pfScore = new float[1];
            int ret = ZYFaceEngine.ZYRecogFaceFtrScore(feature, pnRstID, pfScore);
            SdkStatus s = SdkStatus.jniCode(ret);
            switch (s) {
                case ZY_OK: {
                    if ((double)pfScore[0] < sim) {
                        CodeBean[] codeBeanArray = new CodeBean[]{};
                        return codeBeanArray;
                    }
                    CodeBean r = ZyfFeatureSe.getFeature(pnRstID[0]);
                    r.similarity = pfScore[0];
                    CodeBean[] codeBeanArray = new CodeBean[]{r};
                    return codeBeanArray;
                }
                case ZY_FAIL: {
                    CodeBean[] codeBeanArray = new CodeBean[]{};
                    return codeBeanArray;
                }
            }
            throw new SdkRuntimeException((NativeProductStatus)s);
        }
        finally {
            dblock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeBean getFeature(byte[] featureId) {
        this.checkInitialized();
        ByteBuffer idBuf = ByteBuffer.wrap((byte[])Preconditions.checkNotNull((Object)featureId, (Object)"featureId is null"));
        dblock.lock();
        try {
            Integer id = (Integer)idmap.get((Object)idBuf);
            CodeBean codeBean = id != null ? ZyfFeatureSe.getFeature(id) : null;
            return codeBean;
        }
        finally {
            dblock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addFeature(byte[] featureId, byte[] feature, String imgMD5) {
        this.checkInitialized();
        Preconditions.checkArgument((null != feature && feature.length == 2056 ? 1 : 0) != 0, (String)"INVALID feature data,%s bytes required", (int)2056);
        if (featureId == null) {
            featureId = BinaryUtils.getMD5((byte[])feature);
        }
        dblock.lock();
        try {
            ByteBuffer idBuf = ByteBuffer.wrap(featureId);
            if (!idmap.containsKey((Object)idBuf)) {
                int id = maxId + 1;
                int ret = ZYFaceEngine.ZYAddLibIDTemplet(id, feature, feature.length, addFeatureMode);
                if (ret == 0) {
                    if (0 != ZYFaceEngine.ZYEnableLibNewTplt()) {
                        throw new SdkRuntimeException("FAILT TO enable template");
                    }
                    idmap.put((Object)idBuf, (Object)id);
                    CodeBean codeBean = new CodeBean(featureId, null, imgMD5, null);
                    featureMap.put(idBuf, codeBean);
                    ++maxId;
                    boolean bl = true;
                    return bl;
                }
                SimpleLog.log((String)"WARN:{}", (Object[])new Object[]{SdkStatus.jniCode((int)ret).msg});
            }
        }
        finally {
            dblock.unlock();
        }
        return false;
    }

    public boolean addFeature(byte[] featureId, byte[] feature, long appid) {
        return this.addFeature(featureId, feature, CodeBean.asImgMD5((long)appid));
    }

    public boolean removeFeature(byte[] featureId) {
        ByteBuffer idBuf;
        Integer id;
        this.checkInitialized();
        if (featureId != null && (id = (Integer)idmap.get((Object)(idBuf = ByteBuffer.wrap(featureId)))) != null) {
            dblock.lock();
            try {
                int ret = ZYFaceEngine.ZYDeleteLibIDTemplet(id, -1);
                SdkStatus s = SdkStatus.jniCode(ret);
                switch (s) {
                    case ZY_OK: {
                        idmap.remove((Object)idBuf);
                        featureMap.remove(idBuf);
                        boolean bl = true;
                        return bl;
                    }
                    case ZY_E_EMPTY_TPLTLIB: 
                    case ZY_E_ID_NOT_FOUND: 
                    case ZY_E_TPLT_NOT_FOUND: {
                        boolean bl = false;
                        return bl;
                    }
                }
                throw new SdkRuntimeException((NativeProductStatus)s);
            }
            finally {
                dblock.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        this.checkInitialized();
        dblock.lock();
        try {
            int[] pnNum = new int[1];
            int ret = ZYFaceEngine.ZYGetLibIDNum(pnNum);
            if (ret != 0) {
                throw new SdkRuntimeException((NativeProductStatus)SdkStatus.jniCode(ret));
            }
            if (pnNum[0] != 0) {
                int[] pnID = new int[pnNum[0]];
                ret = ZYFaceEngine.ZYGetLibIDList(pnID, pnNum);
                if (ret != 0) {
                    throw new SdkRuntimeException((NativeProductStatus)SdkStatus.jniCode(ret));
                }
                for (int i = 0; i < pnNum[0]; ++i) {
                    int id = pnID[i];
                    ret = ZYFaceEngine.ZYDeleteLibIDTemplet(id, -1);
                    if (ret != 0) {
                        throw new SdkRuntimeException((NativeProductStatus)SdkStatus.jniCode(ret));
                    }
                    ByteBuffer idBuf = (ByteBuffer)idmap.inverse().remove((Object)id);
                    featureMap.remove(idBuf);
                }
            }
        }
        finally {
            dblock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.checkInitialized();
        dblock.lock();
        try {
            int[] pnNum = new int[1];
            int ret = ZYFaceEngine.ZYGetLibIDNum(pnNum);
            if (ret != 0) {
                throw new SdkRuntimeException((NativeProductStatus)SdkStatus.jniCode(ret));
            }
            int n = pnNum[0];
            return n;
        }
        finally {
            dblock.unlock();
        }
    }

    static void init() {
        if (!dbinitialized) {
            dblock.lock();
            try {
                if (!dbinitialized) {
                    int ret = ZYFaceEngine.ZYInitialLib(0, null, 0);
                    if (ret != 0) {
                        throw new SdkRuntimeException((NativeProductStatus)SdkStatus.jniCode(ret));
                    }
                    dbinitialized = true;
                    return;
                }
            }
            finally {
                dblock.unlock();
            }
        }
        SimpleLog.log((String)"WARN: feature SE was initialized already", (Object[])new Object[0]);
    }

    static {
        ZyfFeatureSe.init();
    }
}

