/*
 * Decompiled with CFR 0.152.
 */
package com.wys.utils.password;

import cn.hutool.crypto.digest.DigestUtil;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class DESUtil {
    private static final Logger logger = Logger.getLogger(DESUtil.class.getName());
    private static final String KEY_ALGORITHM_DESEDE = "DESede";

    public static String encryptMI(String text, String algorithm) {
        if (text == null || StringUtils.isEmpty((CharSequence)text.trim())) {
            return "";
        }
        try {
            StringBuilder sb = new StringBuilder();
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(text.getBytes(StandardCharsets.UTF_8));
            for (char c : DESUtil.encode(md.digest(), true)) {
                sb.append(c);
            }
            return sb.toString();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e.getCause());
            return null;
        }
    }

    public static String md5(String text) {
        return DESUtil.encryptMI(text, "MD5");
    }

    public static String SHA256(String text) {
        return DESUtil.encryptMI(text, "SHA-256");
    }

    public static char[] encode(byte[] data, boolean up) {
        char[] alphabets = (up ? "0123456789abcdef" : "0123456789ABCDEF").toCharArray();
        int len = data.length;
        char[] out = new char[len << 1];
        int var5 = 0;
        for (int i = 0; i < len; ++i) {
            out[var5++] = alphabets[(0xF0 & data[i]) >>> 4];
            out[var5++] = alphabets[0xF & data[i]];
        }
        return out;
    }

    public static byte[] hex(String key) {
        String f = DESUtil.md5(key);
        assert (f != null);
        byte[] bkeys = f.getBytes();
        byte[] enk = new byte[24];
        for (int i = 0; i < 24; ++i) {
            enk[i] = bkeys[i];
        }
        return enk;
    }

    public static String encrypt3Des(String key, String srcStr) {
        byte[] keybyte = DESUtil.hex(key);
        byte[] src = srcStr.getBytes();
        try {
            SecretKeySpec deskey = new SecretKeySpec(keybyte, KEY_ALGORITHM_DESEDE);
            Cipher c1 = Cipher.getInstance(KEY_ALGORITHM_DESEDE);
            c1.init(1, deskey);
            return Base64.encodeBase64String((byte[])c1.doFinal(src));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            logger.log(Level.SEVERE, "", e);
            return null;
        }
    }

    public static String decrypt3Des(String key, String desStr) {
        Base64 base64 = new Base64();
        byte[] keybyte = DESUtil.hex(key);
        byte[] src = base64.decode(desStr);
        try {
            SecretKeySpec deskey = new SecretKeySpec(keybyte, KEY_ALGORITHM_DESEDE);
            Cipher c1 = Cipher.getInstance(KEY_ALGORITHM_DESEDE);
            c1.init(2, deskey);
            return new String(c1.doFinal(src));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
            return null;
        }
    }

    public static void main(String[] args) {
        String key = "2f6cad5632bb1111393bc8b5a5d51bad";
        String text = "dsfdisfdjdsjfdskjfrwiuouewrfeuwhuwe!@##%$%_++|\u6211\u662f\u50bb\u903c~~34dfdsfwer3rewrjeirewur23893iuyr323417ieheewtywdtedtwqdtsayt";
        System.out.println("-----------md5:" + DESUtil.md5(text));
        System.out.println("-----------sha256:" + DESUtil.SHA256("123456"));
        String s1 = "8d969eef6ecad3c29a3a629280e686cf0c3f5d5a86aff3ca12020c923adc6c92";
        String s2 = "8d969eef6ecad3c29a3a629280e686cf0c3f5d5a86aff3ca12020c923adc6c92";
        String s3 = "8d969eef6ecad3c29a3a629280e686cf0c3f5d5a86aff3ca12020c923adc6c92";
        System.out.println("--------sha256Hex" + DigestUtil.sha256Hex((String)"123456"));
        String pwd = DESUtil.encrypt3Des(key, text);
        String str = DESUtil.decrypt3Des(key, pwd);
        System.out.println("----------\u539f\u6587\uff1a" + text);
        System.out.println("----------\u5bc6\u6587\uff1a" + pwd);
        System.out.println("---------\u8fd8\u539f\u540e\uff1a" + str);
    }
}

